<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Models\Admin;
use App\Models\Order;
use App\Models\Payout;
use App\Models\Invitee;
use App\Models\Product;
use App\Models\AdminLog;
use App\Events\MessageSent;
use App\Models\ChatMessage;
use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Models\AdminLoginActivity;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{

    public function index()
    {
        $recentUsers  = Invitee::take(5)->latest('id')->get();
        $config = Configuration::first();
        $adminLogins = AdminLoginActivity::latest('id')->take(10)->get();
        $userStats = Invitee::stats();
        $invitees_with_images = Invitee::where('profile_photo', '!=', null)->count();
        $invitees_without_images = Invitee::where('profile_photo', null)->count();

        return view('admin.dashboard', compact(
            'config',
            'adminLogins',
            'recentUsers',
            'userStats',
            'invitees_with_images',
            'invitees_without_images',
        ));
    }

    function chatPage()
    {
        $users = Admin::select(['id', 'username', 'email'])->whereNot('id', Auth::id())->get();
        return view('admin.chat.index', compact('users'));
    }

    function chatDetails($id, Request $request)
    {
        $user = Admin::findOrFail($id);
        $messages = ChatMessage::query()
            ->where(function ($query) use ($user, $request) {
                $query->where('sender_id', $request->user()->id)
                    ->where('receiver_id', $user->id);
            })
            ->orWhere(function ($query) use ($user, $request) {
                $query->where('sender_id', $user->id)
                    ->where('receiver_id', $request->user()->id);
            })
            ->with(['sender', 'receiver'])
            ->orderBy('id', 'asc')
            ->get();
        return view('admin.chat.details', compact('user','messages'));
    }
    function replyMessage($id, Request $request)
    {
        $user = Admin::findOrFail($id);
        $request->validate([
            'message' => 'required|string'
        ]);

        $message = ChatMessage::create([
            'sender_id' => $request->user()->id,
            'receiver_id' => $user->id,
            'text' => $request->message
        ]);

        broadcast(new MessageSent($message));
        return $message;
        //return view('admin.chat.details', compact('user'));
    }
}
