<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Services\SettingsService;
use App\Http\Controllers\Controller;

class SettingController extends Controller
{
    public function __construct(
        private SettingsService $settingsService
    ) {}
    public function configSetting()
    {
        $config_content = $this->settingsService->getConfigDetails();
        $welcome_ref_bonus = json_decode($config_content->welcome_ref_bonus);
        $three_to_infinity_bonus = json_decode($config_content->three_to_infinity_bonus);
        $unilevel_matching_bonuses = json_decode($config_content->unilevel_matching_bonus);
        //return $welcome_ref_bonus;
        return view('admin.setting.configuration', compact('config_content', 'welcome_ref_bonus', 'unilevel_matching_bonuses'));
    }
    public function aboutUs()
    {
        $about_us = $this->settingsService->getAboutUsDetails();
        return view('admin.setting.about-us', compact('about_us'));
    }
    public function websiteSetting()
    {
        $site_content = $this->settingsService->getSiteDetails();
        return view('admin.setting.website-setting', compact('site_content'));
    }

    public function homePageSetting()
    {
        $home_content = $this->settingsService->gethomePageDetails();
        return view('admin.setting.home-page', compact('home_content'));
    }
    public function distributorPageSetting()
    {
        $distributor_content = $this->settingsService->getDistributorPageDetails();
        return view('admin.setting.distributor-page', compact('distributor_content'));
    }
    public function updateConfigSetting(Request $request)
    {
        //return $request;
        $this->settingsService->updateConfig($request);
        return redirect()->back()->with('message', 'Config Details Updated Successfully!');
    }
    public function updateDistributorPage(Request $request)
    {
        $this->settingsService->updateDistributorPage($request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }
    public function updatehomePage(Request $request)
    {
        $this->settingsService->updatehomePage($request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }
    public function updateSiteSetting(Request $request)
    {
        $this->settingsService->updateWebsite($request);
        return redirect()->back()->with('message', 'Site Details Updated Successfully!');
    }
    public function updateAboutUs(Request $request)
    {
        $this->settingsService->updateAboutPage($request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }
    public function updateSiteLogo(Request $request)
    {
        $request->validate([
            'logo_url' => 'required|image',
        ]);
        SettingsService::updateSiteLogo($request->logo_url);
        return redirect()->back()->with('message', 'Logo Updated Successfully!');
    }
    public function updateSiteFavicon(Request $request)
    {
        $request->validate([
            'favicon_url' => 'required|image',
        ]);
        SettingsService::updateSiteFavicon($request->favicon_url);
        return redirect()->back()->with('message', 'favicon Updated Successfully!');
    }
    public function updateDashboardLogo(Request $request)
    {
        $request->validate([
            'dashboard_logo_url' => 'required|image',
        ]);
        SettingsService::updateDasboardLogo($request->dashboard_logo_url);
        return redirect()->back()->with('message', 'Logo Updated Successfully!');
    }
    // public function updateAboutUsBanner(Request $request)
    // {
    //     $request->validate(
    //         [
    //             'about_side_image' => 'nullable|image'
    //         ],
    //         [
    //             'about_side_image.max' => 'Only image not larger than 2MB'
    //         ]
    //     );
    //     SettingsService::updateAboutUsBanner($request->about_side_image);
    //     return redirect()->back()->with('message', 'Banner Updated Successfully!');
    // }

    public function privacy()
    {
        $privacy = $this->settingsService->getPrivacyDetails();
        return view('admin.setting.privacy', compact('privacy'));
    }

    public function termsAndCondition()
    {
        $terms = $this->settingsService->getTermsDetails();
        return view('admin.setting.terms', compact('terms'));
    }

    public function updatePrivacy(Request $request)
    {
        $this->settingsService->updatePrivacy($request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }
    public function updateTermsAndCondition(Request $request)
    {
        $this->settingsService->updateTermsAndCondition($request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }
}
