<?php

namespace App\Http\Controllers\Auth;

use Carbon\Carbon;
use App\Models\Epin;
use App\Models\User;
use App\Mail\NewUserMail;
use App\Models\UserWallet;
use App\Models\BinaryWallet;
use App\Models\IncomeWallet;
use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Models\PaymentHistory;
use App\Services\CacheService;
use App\Models\MembershipHistory;
use App\Models\TransactionWallet;
use Illuminate\Support\Facades\DB;
use App\Services\CommissionService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Models\UnilevelActivationUser;
use App\Models\UserPackageHistory;
use App\Models\UserSubscription;
use App\Services\PaystackPaymentService;
use App\Services\AutomaticUserPlacementService;

class RegistrationFeeController extends Controller
{
    public function __construct(
        private CommissionService $commissionService
    ) {}

    public function index()
    {
        $user = Auth::user();
        if (!$user->paymentInfo) {
            return redirect()->route('payment.show');
        }
        if ($user->registration_fee == 1) {
            return redirect()->route('dashboard');
        }

        $config = Configuration::first();
        $wallet = Auth::guard('web')->user()->wallet ? Auth::guard('web')->user()->wallet->transaction_wallet : 0;

        return view('auth.registration-fee', compact('wallet', 'config'));
    }
    public function feePaid()
    {

        return view('auth.registration-fee-paid');
    }

    public function processPayment(Request $request)
    {
        CacheService::removeAll();

        $user = $request->user_id ? User::find($request->user_id) : Auth::user();

        if (!$user) {
            return redirect()->back()->with('error', 'Oops! Something went wrong, please try it again later.');
        }

        if ($user->registration_fee) {
            return redirect()->back()->with('error', 'Registration fee already paid');
        }

        $config = CacheService::configuration();
        $wallet = UserWallet::where('user_id', Auth::user()->id)->first();

        if (strtolower($request->payment_method) == 'wallet') {
            if (!$config || !$wallet || $wallet->transaction_wallet < $config->registration_fee) {
                return redirect()->back()->with('error', 'You do not have enough money in your transaction wallet');
            }
        }

        if (strtolower($request->payment_method) == "paystack") {
            $callbackUrl = route('paystack-regfee-method');

            $formData = [
                'email' => $user->email,
                'name' => $user->first_name,
                'amount' => $config->registration_fee * 100,
                "currency" => "NGN",
                'callback_url' => $callbackUrl,
            ];

            session(['amount' => $request->amount]);

            $pay = json_decode(PaystackPaymentService::initiate_payment($formData));

            if ($pay) {
                if ($pay->status == true) {
                    // return response()->json(['status' => 'success', 'code' => $pay->data->authorization_url]);
                    return redirect($pay->data->authorization_url);
                } else {
                    return redirect()->back()->with("error", $pay->message);
                }
            } else {
                return redirect()->back()->with("error", "Something went wrong");
            }
        }


        if (strtolower($request->payment_method) == 'epin') {
            if (!$request->epin_code) {
                return redirect()->back()->with('error', 'Please enter a valid Epin code');
            } else {
                $epin = Epin::where('code', $request->epin_code)
                    ->where('type', 'registration')
                    ->where('status', 'valid')
                    ->first();

                if (!$epin) {
                    return redirect()->back()->with('error', 'Invalid Epin entered or Epin already been used');
                }
            }
        }

        if (strtolower($request->payment_method) == 'epin' && $epin) {

            $update = $this->paymentUpdateHelper($user, $config, 'Epin - #' . $epin->code, null, $epin);

            if ($update) {
                Mail::to($user->email)->send(new NewUserMail($user));
                //return redirect()->route('placement-setting', ['from' => 'auth']);
                return redirect()->route('fee-payment.paid')->with('status', 'Registration fee payment was successful');
            }
        } else if (strtolower($request->payment_method) == 'wallet' && $wallet) {
            $update = $this->paymentUpdateHelper($user, $config, 'Transaction wallet', $wallet);

            if ($update) {
                Mail::to($user->email)->send(new NewUserMail($user));
                // return redirect()->route('placement-setting', ['from' => 'auth']);
                return redirect()->route('fee-payment.paid')->with('status', 'Registration fee payment was successful');
            }
        }

        return redirect()->back()->with('error', 'Something went wrong, we could not process this request.');
    }
    
    public function paystackMethod()
    {
        $user = Auth::user();
        $config = CacheService::configuration();
        DB::beginTransaction();
        try {
            $update = $this->paymentUpdateHelper($user, $config, 'paystack');

            DB::commit();
            if ($update) {
                return redirect()
                    ->route('fee-payment.paid')
                    ->with('status', 'Registration fee payment was successful');
            }
        } catch (\Exception $e) {
            return response()->json($e);
            DB::rollBack();
        }

        return redirect()
            ->back()
            ->with('error', 'Opps! Something went wrong, please try it again.');
    }
    private function paymentUpdateHelper($user, $config, $method,  $wallet = null, $epin = null)
    {
        DB::beginTransaction();
        $history = PaymentHistory::create([
            'user_id' => $user->id,
            'payer_id' => Auth::user()->id,
            'type' => 'registration',
            'amount' => $config->registration_fee,
            'method' => $method,
        ]);
        MembershipHistory::create([
            'user_id' => $user->id,
            'fee' => $config->registration_fee,
            'next_due_date' => Carbon::now()->addYear()
        ]);
        $userUpdate = User::find($user->id)->update([
            'rank' => 'Member',
            'status' => 'Active',
            'registration_fee' => 1,
            'registration_fee_date' => Carbon::now()->toDateTimeString(),
            'next_due_date' => Carbon::now()->addYear()
        ]);

        if ($epin) {
            $epin->used_by = ucfirst($user->username);
            $epin->status = 'used';
            $epin->date_used = Carbon::now()->toDateTimeString();
            $epin->save();
        } elseif ($wallet) {
            $wallet->transaction_wallet -= $config->registration_fee;
            $wallet->save();
            TransactionWallet::create([
                'user_id' => Auth::user()->id,
                'debit' => $config->registration_fee,
                'remark' => 'Registration fee payment',
            ]);
        }

        if ($history && $userUpdate) {
            BinaryWallet::create(['user_id' => $user->id]);

            UnilevelActivationUser::recorder($user);
            //Update User to Package One
            UserSubscription::create([
                'user_id' => $user->id,
                'package_id' => 1,
            ]);
            // UserPackageHistory::create([
            //     'user_id' => $user->id,
            //     'type' => ''
            //     'bv',
            //     'package_data',
            // ]);
            AutomaticUserPlacementService::addToPlacement($user->referral, $user);
            BinaryWallet::binaryQualifyUpdator();

            // Must only run after the automatic placement
            // The "User::find($user->id)" is used below to get the updated row after the auto placement
            $actor = User::find($user->id);
            BinaryWallet::updateBinaryTeam($actor, $actor, 20);

            // Welcome bonus commission
            $this->commissionService->welcomeBonus($user);

            DB::commit();

            return true;
        }

        DB::rollBack();

        return false;
    }


    private function welcomeBonus($user)
    {
        $config = Configuration::first();
        $welBonusObj = json_decode($config->welcome_ref_bonus);
        $levelDeepCounts = count($welBonusObj);

        $uplines = User::uplineByReferral($user->id, $levelDeepCounts);

        foreach ($uplines as $index => $value) {
            $bonus = ((float) $config->registration_fee * (int) $welBonusObj[$index]->bonus) / 100;

            if ($index == 0) {
                $remark = 'Welcome bonus from ' . ucfirst($user->username);
            } else {
                $remark = 'Level-' . ($index + 1) . ' welcome bonus from ' . ucfirst($user->username);
            }

            if ($value && $value->id && $bonus > 0) {
                IncomeWallet::create([
                    'user_id' => $value->id,
                    'type' => 'welcome',
                    'amount' => $bonus,
                    'remark' => $remark,
                ]);

                $userWallet = UserWallet::where('user_id', $value->id)->first();

                if ($userWallet) {
                    $userWallet->master_wallet += $bonus;
                    $userWallet->welcome_b += $bonus;
                    $userWallet->save();
                } else {
                    UserWallet::create([
                        'user_id' => $value->id,
                        'master_wallet' => $bonus,
                        'welcome_b' => $bonus,
                    ]);
                }
            }
        }

        return true;
    }
}
