<?php

namespace App\Http\Controllers;

use App\Models\Invitee;
use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Services\UploadService;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

class HomeController extends Controller
{
    function home()
    {
        return view('home');
    }
      public function migrate(): JsonResponse
    {
        Artisan::call('migrate', [
            '--force' => true
        ]);

        return response()->json([
            'message' => 'Migration completed successfully.',
            'output' => Artisan::output(),
        ]);
    }

    function index()
    {

        return view('welcome');
    }
    function onLine()
    {

        return view('online');
    }

    function paymentPage()
    {
        //return session('reg_category');
        if (!session('reg_type')) {
            return redirect('/');
        }
        $config = Configuration::first();
        $total = 0;
        $total_fee = 0;
        $stotal_fee = 0;
        $children_fee = 0;
        $student_fee = 0;
        $adult_fee = 0;

        if (session('reg_type') == "bulk") {
            $categories = json_decode(session('reg_category2'));
            $total = session('total');
            foreach ($categories as $key => $value) {
                //return $value;
                if ($value == "Children") {
                    $children = $this->count_array_values($categories, "Children");
                    $children_fee = $config->child_reg_fee * $children;
                }
                if ($value == "Teenager") {
                    $student = $this->count_array_values($categories, "Teenager");
                    $student_fee = $config->student_reg_fee * $student;
                }
                if ($value == "Adult") {
                    $adult = $this->count_array_values($categories, "Adult");
                    $adult_fee = $config->adult_reg_fee * $adult;
                }
            }
        }

        if (session('reg_type') == "personal" && session('reg_category') == "Children") {
            $total = 1;
            $stotal_fee = $config->child_reg_fee;
        }
        if (session('reg_type') == "personal" && session('reg_category') == "Adult") {
            $total = 1;
            $stotal_fee = $config->adult_reg_fee;
        }
        if (session('reg_type') == "personal" && session('reg_category') == "Teenager") {
            $total = 1;
            $stotal_fee = $config->student_reg_fee;
        }
        $total_fee = ($children_fee + $student_fee + $adult_fee);
        return view('payment', compact('config', 'total_fee', 'stotal_fee', 'total'));
    }

    function regSuccess()
    {
        if (session('reg_type')) {
            return redirect('/');
        }
        return view('success');
    }

    function storeInvitee(Request $request)
    {
        if ($request->reg_type == "personal") {
            $request->validate(
                [
                    'single_first_name' => 'required',
                    'email' => 'required',
                    'gender' => 'required',
                    'phone' => 'required',
                    'marital_status' => 'required',
                    'reg_category' => 'required',
                ],
                [
                    'single_first_name.required' => 'Please enter your name',
                    'email.required' => 'Please enter your email',
                    'gender.required' => 'Please select your gender',
                    'phone.required' => 'Please enter your contact',
                    'marital_status.required' => 'Please select your marital status',
                    'reg_category.required' => 'Please select registeration category',
                ]
            );
        }
        if ($request->reg_type == "bulk") {
            $request->validate(
                [
                    'author' => 'required',
                    'author_email' => 'required|email',
                    'author_contact' => 'required',
                ],
                [
                    'author.required' => 'Please enter sponsor\'s name',
                    'author_email.required' => 'Please enter sponsor\'s email',
                    'author_contact.required' => 'Please enter sponsor\'s contact',
                ]
            );
        }
        if (session('reg_type')) {
            session()->flush([
                'reg_type',
                'reg_category',
                'reg_category2',
                'age_group',
                'age_group2',
                'author',
                'author_email',
                'author_contact',
                'first_name',
                'email',
                'email2',
                'phone',
                'phone2',
                'gender',
                'single_first_name',
                'single_last_name',
                'total'
            ]);
        }
        session([
            'reg_type' => $request->reg_type,
            'reg_category' => $request->reg_category,
            'age_group' => $request->age_group,
            'author' => $request->author,
            'marital_status' => $request->marital_status,
            'author_email' => $request->author_email,
            'author_contact' => $request->author_contact,
            'gender' => $request->gender,
            'phone' => $request->phone,
            'total' => $request->first_name ? count($request->reg_category2) : 1,
            'email' => $request->email,
            'reg_category2' => json_encode($request->reg_category2),
            'first_name' => json_encode($request->first_name),
            'phone2' => json_encode($request->phone2),
            'age_group2' => json_encode($request->age_group2),
            'email2' => json_encode($request->email2),
            'single_first_name' => $request->single_first_name,
            'single_last_name' => $request->single_last_name,
        ]);

        return redirect()->route('reg-payment');
    }

    function regInvitee(Request $request)
    {
        DB::beginTransaction();
        if (session('reg_type')) {
            try {
                if (session('reg_type') == "bulk") {
                    $names = [
                        'fname' => json_decode(session('first_name')),
                        'type' => json_decode(session('reg_category2')),
                        'age_group' => json_decode(session('age_group2')),
                        'email' => json_decode(session('email2')),
                        'phone' => json_decode(session('phone2'))
                    ];
                    for ($i = 0; $i < count(json_decode(session('first_name'))); $i++) {
                        Invitee::create([
                            'first_name' => $names['fname'][$i],
                            'email' => $names['email'][$i],
                            'phone' => $names['phone'][$i],
                            'category' => $names['type'][$i],
                            'age_group' => $names['age_group'][$i],
                            'author_email' => session('author_email'),
                            'author_contact' => session('author_contact'),
                            'author' => session('author'),
                            'reg_type' => session('reg_type'),
                            'reg_mode' => $request->reg_type,
                            'invitee_id' => substr(rand(1, 100000000), 0, 6),
                        ]);
                        set_time_limit(60 * 60);
                    }
                }
                if (session('reg_type') == "personal") {

                    Invitee::create([
                        'first_name' => session('single_first_name'),
                        'last_name' => session('single_last_name'),
                        'category' => session('reg_category'),
                        'reg_type' => session('reg_type'),
                        'age_group' => session('age_group'),
                        'email' => session('email'),
                        'marital_status' => session('marital_status'),
                        'author_email' => session('email'),
                        'phone' => session('phone'),
                        'gender' => session('gender'),
                        'author' => session('single_first_name'),
                        'reg_mode' => $request->reg_type,
                        'invitee_id' => substr(rand(1, 100000000), 0, 6),
                    ]);
                }

                DB::commit();
                if (session('reg_type')) {
                    session()->flush([
                        'reg_type',
                        'reg_category',
                        'reg_category2',
                        'age_group',
                        'age_group2',
                        'author',
                        'author_email',
                        'marital_status',
                        'author_contact',
                        'first_name',
                        'email',
                        'email2',
                        'phone',
                        'phone2',
                        'gender',
                        'single_first_name',
                        'single_last_name',
                        'total'
                    ]);
                }
                return redirect()->route('reg-success');
            } catch (\Exception $e) {
                return $e;
                DB::rollBack();
            }
        }
        return redirect()->back('error', 'Opps! Something went wrong, please try it again.');
    }

    function inviteeProfile()
    {
        return view('invitee-profile');
    }

    function searchInvitee(Request $request)
    {
        $request->validate([
            'phone' => 'required'
        ]);
        $invitee = Invitee::where('phone', $request->phone)->first();
        if (!$invitee) {
            return redirect()->back()->with('error', 'Phone number not found');
        }
        return redirect()->route('invitee-details', ['name' => str_replace(' ', '-', $invitee->first_name), 'invitee_id' => $invitee->invitee_id]);
    }

    function inviteeDetails($name, $invitee_id)
    {
        $invitee = Invitee::where('invitee_id', $invitee_id)->first();
        if (!$invitee) {
            return redirect()->back();
        }
        return view('invitee-details', compact('invitee'));
    }

    function updateInvitee(Request $request)
    {
        $invitee = Invitee::where('first_name', $request->first_name)->first();
        if (!$invitee) {
            return redirect()->back();
        }
        if ($request->photo) {
            $fileName = $invitee->first_name . '_' . time() . '.' . $request->photo->getClientOriginalExtension();
            $img_url = UploadService::upload($request->photo, 'invitees', $fileName);
        }
        $invitee->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone' => $request->phone,
            'email' => $request->email,
            'gender' => $request->gender,
            'profile_photo' => $request->photo ? $img_url : $invitee->photo,
        ]);
        return redirect()->back()->with('message', 'Details Updated successfully!');
    }

    function onlinePayment()
    {
        DB::beginTransaction();
        if (session('reg_type')) {
            try {
                if (session('reg_type') == "bulk") {
                    foreach (json_decode(session('first_name')) as $key => $file) {
                        Invitee::create([
                            'first_name' => $file,
                            'author' => session('author'),
                            'author_email' => session('author_email'),
                            'category' => session('reg_category'),
                            'reg_type' => session('reg_type'),
                            'reg_mode' => 'online',
                        ]);
                        set_time_limit(60 * 60);
                    }
                }
                if (session('reg_type') == "personal") {

                    Invitee::create([
                        'first_name' => session('single_first_name'),
                        'last_name' => session('last_name'),
                        'category' => session('reg_category'),
                        'reg_type' => session('reg_type'),
                        'email' => session('email'),
                        'author_email' => session('email'),
                        'phone' => session('phone'),
                        'gender' => session('gender'),
                        'author' => session('single_first_name'),
                        'reg_mode' => 'online',
                    ]);
                }

                DB::commit();
                if (session('reg_type')) {
                    session()->flush([
                        'reg_type',
                        'reg_category',
                        'author',
                        'author_email',
                        'first_name',
                        'last_name',
                        'email',
                        'phone',
                        'gender',
                        'single_first_name',
                        'total'
                    ]);
                }
                return redirect('/');
            } catch (\Exception $e) {
                return response()->json($e);
                DB::rollBack();
            }
        }
        return response()->json(['status' => 'error', 'message' => 'Opps! Something went wrong, please try it again.']);
    }


    //  function onlinePayment() {
    //     DB::beginTransaction();
    //     if (session('reg_type')) {
    //         try {
    //             if (session('reg_type') == "bulk") {
    //                 foreach (json_decode(session('first_name')) as $key => $file) {
    //                      Invitee::create([
    //                         'first_name' => $file,
    //                         'author' => session('author'),
    //                         'author_email' => session('author_email'),
    //                         'category' => session('reg_category'),
    //                         'reg_type' => session('reg_type'),
    //                         'reg_mode' => 'online',
    //                     ]);
    //                     set_time_limit(60 * 60);
    //                 }

    //             }
    //             if (session('reg_type') == "personal") {

    //                     Invitee::create([
    //                         'first_name' => session('single_first_name'),
    //                         'last_name' => session('last_name'),
    //                         'category' => session('reg_category'),
    //                         'reg_type' => session('reg_type'),
    //                         'email' => session('email'),
    //                         'author_email' => session('email'),
    //                         'phone' => session('phone'),
    //                         'gender' => session('gender'),
    //                         'author' => session('single_first_name'),
    //                         'reg_mode' => 'online',
    //                     ]);
    //             }

    //             DB::commit();
    //             if (session('reg_type')) {
    //                 session()->flush([
    //                 'reg_type',
    //                 'reg_category',
    //                 'author',
    //                 'author_email',
    //                 'first_name',
    //                 'last_name',
    //                 'email',
    //                 'phone',
    //                 'gender',
    //                 'single_first_name',
    //                 'total'
    //                 ]);
    //             }
    //             return redirect('/');
    //              } catch (\Exception $e) {
    //             return response()->json($e);
    //             DB::rollBack();
    //         }
    //     }
    //      return response()->json(['status' => 'error', 'message' => 'Opps! Something went wrong, please try it again.']);

    // }


    function count_array_values($my_array, $match)
    {
        $count = 0;

        // Iterate through each element in the array
        foreach ($my_array as $key => $value) {
            // Check if the current element matches the specified value
            if ($value == $match) {
                // Increment the count if a match is found
                $count++;
            }
        }

        // Return the total count of occurrences
        return $count;
    }
}
