<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Epin extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'admin_id',
        'type',
        'amount',
        'code',
        'used_by',
        'date_used',
        'status',
    ];
    function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT ROUND(COUNT(`id`), 2) FROM `epins`) AS total_epins,
                (SELECT ROUND(COUNT(`id`), 2) FROM `epins` WHERE `status`='used' ) AS used_epins,
                (SELECT ROUND(COUNT(`id`), 2) FROM `epins` WHERE `status`='valid' ) AS valid_epins
            "
        )[0];
    }
}
