<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class IncomeWallet extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'type',
        'rank_level',
        'promo_level',
        'amount',
        'e_points',
        'remark',
        'tracker_id',
    ];
   
    public function user(): BelongsTo
    {
        return $this->BelongsTo(User::class, 'user_id');
    }
  
    public static function earningStats($userID)
    {
        return DB::select(
            "SELECT
                (SELECT master_wallet FROM `user_wallets` WHERE user_id=$userID) AS master_wallet,
                (SELECT transaction_wallet FROM `user_wallets` WHERE user_id=$userID) AS transaction_wallet,
                (SELECT SUM(`amount`) FROM `income_wallets` WHERE user_id=$userID) AS total_earnings,
                (SELECT SUM(`debit`) FROM `transaction_wallets` WHERE user_id=$userID) AS total_spent,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='approved') AS approved_payout,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='pending') AS pending_payout,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='cancelled') AS cancelled_payout,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='welcome' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS welcome_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='affiliate' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS affiliate_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='influencer' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS influencer_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='team_bonus' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS team_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='unilevel_activation' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS unilevel_activation_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='unilevel_matching' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS unilevel_matching_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='three_to_infinity' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS three_to_infinity_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='promo' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS promo_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='stockist' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS stockist_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='referral' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS referral_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='binary' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS binary_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='rank' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS rank_commission_month
            "
        )[0];
    }
    
}
