<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class Invitee extends Model
{
    protected $fillable = [
        'first_name',
        'last_name',
        'author',
        'author_email',
        'author_contact',
        'phone',
        'email',
        'profile_photo',
        'marital_status',
        'gender',
        'category',
        'age_group',
        'reg_type',
        'reg_mode',
        'invitee_id',
        'status',
    ];
    static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT COUNT(`id`) FROM `invitees`) AS total_invitees,
                (SELECT COUNT(`id`) FROM `invitees` WHERE status=1 ) AS approved_invitees,
                (SELECT COUNT(`id`) FROM `invitees` WHERE status=0) AS pending_invitees
            "
        )[0];
    }
}
