<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\LeadershipBonus;
use Illuminate\Support\Facades\Auth;

class LeadershipBonuslService
{
    public static function allBonuses($take)
    {
        return LeadershipBonus::oldest('id')->paginate($take ? $take :20);
    }
    public static function store($data)
    {
        $bonus = LeadershipBonus::create([
            'rank_id' => $data->rank_id,
            'profit' => $data->profit
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $bonus->id,
            'leadership_bonuses',
            ucfirst(Auth::user()->username) . ' Added new Bonus '
        );
    }
    public static function edit($id)
    {
        $bonus = LeadershipBonus::find($id);
        return $bonus;
    }
    public static function update($id, $data)
    {
        $bonus = LeadershipBonus::find($id);

        $bonus->update([
            'profit' => $data->profit
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $bonus->id,
            'leadership_bonuses',
            ucfirst(Auth::user()->username) . ' Updated Bonus Details'
        );
    }


    public static function delete($id)
    {
        $bonus = LeadershipBonus::find($id);
        $bonus->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $bonus->id,
            'leadership_bonuses',
            ucfirst(Auth::user()->username) . ' Deleted Bonus Details'
        );
    }
}
