<?php

namespace App\Services;

use App\Models\Product;
use App\Models\AdminLog;
use Illuminate\Support\Str;
use App\Models\ProductCategory;
use Illuminate\Support\Facades\Auth;

class ProductCategoryService
{
    public static function allCategories($take)
    {
        return ProductCategory::paginate($take ?: 20);
    }

    public static function store($data)
    {

        $category = ProductCategory::create([
            'name' => $data->name,
            'slug' => Str::slug($data->name),
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $category->id,
            'product_categories',
            ucfirst(Auth::user()->username) . ' Added new Product Category'
        );
    }
    public static function edit($id)
    {
        $category = ProductCategory::find($id);
        return $category;
    }
    public static function update($id, $data)
    {
        $category = ProductCategory::find($id);
        $category->update([
            'name' => $data->name,
            'slug' => Str::slug($data->name),
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $category->id,
            'product_categories',
            ucfirst(Auth::user()->username) . ' Updated Category Detials'
        );
    }

    public static function delete($id)
    {
        $category = ProductCategory::find($id);
        $category->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $category->id,
            'product_categories',
            ucfirst(Auth::user()->username) . ' Deleted Category Details'
        );
    }
}
