<?php

namespace App\Services;

use App\Models\Product;
use App\Models\AdminLog;
use App\Models\ProductFaq;
use App\Services\UploadService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class ProductService
{
    public static function allProducts($take)
    {
        return Product::paginate($take ?: 20);
    }

    public static function store($data)
    {
        // $faqs = [
        //     'question' => $data->question,
        //     'answer' => $data->answer
        // ];
        if (file($data->image)) {
            $fileName = $data->name . '_' . time() . '.' . $data->image->getClientOriginalExtension();
            $img_url = UploadService::upload($data->image, 'Products', $fileName);
        }
        // if (file($data->hover_img)) {
        //     $fileName = $data->name . '_' . time();
        //     $hover_img = UploadService::upload($data->hover_img, 'Product-hover-images', $fileName);
        // }
        $product = Product::create([
            'sku' => $data->sku,
            'name' => $data->name,
            'category_id' => $data->category,
            'quantity' => $data->quantity,
            'vat' => $data->vat,
            'point_value' => $data->point_value,
            'quantity' => $data->quantity,
            'size' => $data->size,
            'price' => $data->price,
            'featured_img' => $img_url,
            // 'hover_img' => $hover_img,
            'description' => $data->description,
            'available_quantity' => $data->quantity
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $product->id,
            'products',
            ucfirst(Auth::user()->username) . ' Added new Product'
        );
    }
    public static function edit($id)
    {
        $product = Product::find($id);
        return $product;
    }
    public static function update($id, $data)
    {

        $product = Product::find($id);
        if ($data->image) {
            if (File::exists(public_path($product->featured_img))) {
                File::delete(public_path($product->featured_img));
            }
            $fileName = str_replace(' ', '', $product->name) . '_' . time() . '.' . $data->image->getClientOriginalExtension();
            $img_url = UploadService::upload($data->image, 'Products', $fileName);
        }
        $product->update([
            'name' => $data->name,
            'quantity' => $data->quantity,
            'category_id' => $data->category,
            'vat' => $data->vat,
            'status' => $data->status,
            'point_value' => $data->point_value,
            'quantity' => $data->quantity,
            'price' => $data->price,
            'featured_img' => $data->image ? $img_url : $product->featured_img,
            'category' => $data->category,
            'description' => $data->description,
            'available_quantity' => $data->quantity - $product->sold,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $product->id,
            'products',
            ucfirst(Auth::user()->username) . ' Updated Product Detials'
        );
    }
    public static function updateImage($id, $image)
    {
        $product = Product::find($id);
        if (File::exists(public_path($product->featured_img))) {
            File::delete(public_path($product->featured_img));
        }
        $fileName = str_replace(' ', '', $product->name) . '_' . time();
        $img_url = UploadService::upload($image, 'Products', $fileName);
        $product->update([
            'featured_img' => $img_url,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $product->id,
            'products',
            ucfirst(Auth::user()->username) . ' Updated Product Image'
        );
    }
   
    public static function delete($id)
    {
        $product = Product::find($id);
        if (File::exists(public_path($product->featured_img))) {
            File::delete(public_path($product->featured_img));
        }
        $product->delete();
        AdminLog::createAdminLog(
            Auth::user()->id,
            $product->id,
            'products',
            ucfirst(Auth::user()->username) . ' Deleted Product Details'
        );
    }
    function cart($carts, $wallet)
    {
        $totalPrice = 0;
        $grandTotalBV = 0;
        $vatTotal = 0;

        foreach ($carts as $cart) {
            $totalPrice += ($cart->quantity * $cart->product->price);
            $vatTotal += ($cart->quantity * (($cart->product->price * $cart->product->vat) / 100));
            $grandTotalBV += ($cart->quantity * $cart->product->point_value);
        }

        $grandTotal = $totalPrice + $vatTotal;

        $balanceToPay = $grandTotal;
        if ($wallet) {
            if ($wallet->transaction_wallet >= $totalPrice) {
                $balanceToPay =  0;
            } else {
                $balanceToPay =  $grandTotal - $wallet->transaction_wallet;
            }
        }

        return [
            'totalPrice' => $totalPrice,
            'grandTotalBV' => $grandTotalBV,
            'vatTotal' => $vatTotal,
            'balanceToPay' => $balanceToPay,
        ];
    }
}
