<?php

namespace App\View\Components;

use Closure;
use App\Models\Product;
use App\Models\ProductCart;
use Illuminate\View\Component;
use App\Models\ProductCategory;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;

class ProductView extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $take = 20;
        if (request()->product_category && strtolower(request()->product_category) != 'all') {
            $products = Product::where('category', 'like', request()->product_category)->paginate($take);
        }
        else if (request()->keyword) {
            $products = Product::where('name', 'like', '%'.request()->keyword.'%')->paginate($take);
        }
        else {
            $products = Product::paginate($take);
        }

        return view('components.product-view', [
            // 'categories' => ProductCategory::all(),
            'products' => $products,
            'cartCnt' => ProductCart::where('added_by', Auth::user()->id)->sum('quantity'),
        ]);
    }
}
