@extends('layouts.admin')
@section('title','Dashboard')
@section('content')
<div class="title pb-20">
    <h2 class="h3 mb-0">Hello, {{Auth::guard('admin')->user()->username}}</h2>
</div>
@if(Auth::guard('admin')->user()->role == "super")
<div class="row pb-10">
    <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($userStats->total_invitees)}}</div>
                    <div class="font-14 text-secondary weight-500">
                        All Invitees
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($userStats->approved_invitees)}}</div>
                    <div class="font-14 text-secondary weight-500">
                     Confirmed Invitees
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($userStats->pending_invitees)}}</div>
                    <div class="font-14 text-secondary weight-500">
                      Pending Invitees
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row pb-10">
    {{-- <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($userStats->total_invitees)}}</div>
                    <div class="font-14 text-secondary weight-500">
                        All Invitees
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}
    <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($invitees_without_images)}}</div>
                    <div class="font-14 text-secondary weight-500">
                        Invitees without Profile Photo
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
        <div class="card-box height-100-p widget-style3">
            <div class="d-flex flex-wrap">
                <div class="widget-data">
                    <div class="weight-700 font-24 text-dark">{{number_format($invitees_with_images)}}</div>
                    <div class="font-14 text-secondary weight-500">
                      Invitees with Profile Photo
                    </div>
                </div>
                <div class="widget-icon">
                    <div class="icon" data-color="#00eccf">
                        <i class="icon-copy bi bi-people"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
  <div class="pt-3"></div>
{{-- Recent Users --}}
<div class="card-box pb-10 pt-5">
    <div class="h5 pd-20 mb-0">Recent Registered Invitees</div>
    <table class="table nowrap">
        <thead>
            <tr>
                <th class="table-plus">Name</th>
                <th>Email</th>
                <th>Profile Image</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($recentUsers as $user)
            <tr>
                <td>{{ucfirst($user->first_name)}}</td>
                <td>{{ucfirst($user->author_email)}}</td>
                <td>
                    @if ($user->profile_photo)
                    <span class="btn btn-sm btn-success text-white">Uploaded</span>
                    @else
                    <span class="btn btn-sm btn-danger text-white">Absent</span>
                    @endif
                </td>
                <td>
                    @if ($user->status == 0)
                    <span class="btn btn-sm btn-secondary text-white">Pending</span>
                    @endif
                </td>
                <td>
                    <x-date-format :date="$user->created_at" />
                </td>
            </tr>
            @empty
            <table>
                <tr>
                    <p class="text-center">No record found</p>
                </tr>
            </table>
            @endforelse

        </tbody>
    </table>
</div>

@endif
@endsection
