<?php

namespace App\Http\Controllers\Admin;

use App\Models\Invitee;
// use Barryvdh\DomPDF\PDF;
use App\Mail\RegConfirmation;
use App\Services\UserService;
use App\Exports\InviteeExport;
use App\Models\WebsiteSetting;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use App\Mail\PaymentConfirmation;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;

class InviteeManagerController extends Controller
{
    public function __construct(
        private UserService $userService,
    ) {}

    public function index($status = '')
    {
        if (request()->search) {
            $invitee = Invitee::select('first_name', 'phone')->where('first_name', request()->search)->orWhere('phone', request()->search)->first();
            if ($invitee) {
                $query = Invitee::where('first_name', request()->search)->orWhere('phone', request()->search);
            } else {
                return redirect()->back()->with('error', 'No record found for your entry!');
            }
        } else {
            $query = Invitee::latest('id');
        }

        $invitees = $query->paginate(request()->take ?: 20);
        $userStats = Invitee::stats();
        $invitees_with_images = Invitee::where('profile_photo', '!=', null)->count();
        $invitees_without_images = Invitee::where('profile_photo', null)->count();

        return view('admin.invitee.index', compact('invitees', 'userStats', 'invitees_without_images', 'invitees_with_images'));
    }

    public function details($id)
    {
        $invitee = Invitee::find($id);
        if (!$invitee) {
            return redirect()->back();
        }
        return view('admin.invitee.details', compact('invitee'));
    }

    public function approveInvitee($id)
    {
        $invitee = Invitee::find($id);
        $site_details = WebsiteSetting::first();
        if (!$invitee) {
            return redirect()->back()->with('error', 'No record found');
        }
        $invitee->update([
            'status' => 1
        ]);
        $detail = [
            'name' => $invitee->author
        ];
        Mail::to($invitee->author_email)->send(new RegConfirmation($detail));
        Mail::to($site_details->business_email)->send(new PaymentConfirmation($detail));
        return redirect()->back()->with('message', 'Payment Confirmed successfully!');
    }
    public function exportInvitee()
    {
        return Excel::download(new InviteeExport, 'invitees.xlsx');
    }

    public function printId(Invitee $student)
    {
        $pdf = PDF::loadView('id-card-pdf', ["students" => [$student]]);
        $pdf->setPaper('A4', '');
        return $pdf->stream($student->first_name . "_" . $student->last_name . "-" . str_pad($student->id + 1, 4, '0', STR_PAD_LEFT) . '.pdf');
    }
    public function printIdBulk()
    {
        $site_details = WebsiteSetting::first();
        $pdf = PDF::loadView('id-card-pdf', ["invitees" => Invitee::all(), 'site_details' => $site_details]);
        $pdf->setPaper('A4', '');
        return $pdf->stream('all-diu-student-id.pdf');
    }

    // use Barryvdh\DomPDF\Facade\Pdf;

    // $pdf = Pdf::loadView('pdf.invoice', $data);
    // return $pdf->download('invoice.pdf');
}
