<?php

namespace App\Livewire;

use Livewire\Component;
use App\Events\MessageSent;
use App\Models\ChatMessage;

class ChatUI extends Component
{
    public $user;
    public $text = '';

    public function render()
    {
        $user = $this->user;
        $messages = ChatMessage::query()
            ->where(function ($query) use ($user) {
                $query->where('sender_id', auth()->user()->id)
                    ->where('receiver_id', $user->id);
            })
            ->orWhere(function ($query) use ($user) {
                $query->where('sender_id', $user->id)
                    ->where('receiver_id', auth()->user()->id);
            })
            ->with(['sender', 'receiver'])
            ->orderBy('id', 'asc')
            ->get();
        return view('livewire.chat-u-i', compact('messages'));
    }
    public function save()
    {
        $message = ChatMessage::create([
            'sender_id' => auth()->user()->id,
            'receiver_id' => $this->user->id,
            'text' =>  $this->text
        ]);

        broadcast(new MessageSent($message));
        $this->reset('text');
    }
}
