<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Order extends Model
{
   
    protected $fillable = [
        'user_id',
        'product_id',
        'order_number',
        'type',
        'created_by',
        'quantity',
        'received_qty',
        'amount',
        'total',
        'shipping_fee',
        'bv',
        'total_bv',
        'shipping_method',
        'payment_method',
        'product_name',
        'product_data',
        'package_info',
        'status',
        'delivery_date',
        'shipped_date'
    ];

    public function created_by(): BelongsTo
    {
        return $this->BelongsTo(User::class,'created_by');
    }

    public function user(): BelongsTo
    {
        return $this->BelongsTo(User::class,'user_id')->withDefault([
            'name' => 'guest'
        ]);
    }
    public function product(): BelongsTo
    {
        return $this->BelongsTo(Product::class,'product_id');
    }
    public static function monthlySumPVPercentage($userID)
    {
        $user = User::select('country')->where('id', $userID)->first();
        $mStart = Carbon::today()->startOfMonth();
        $mEnd = $mStart->copy()->endOfMonth();
        $config = Configuration::first();

        $resp = self::where([
            ['type', 'Reorder'], ['user_id', $userID]
        ])->whereBetween('created_at', [$mStart, $mEnd])->sum('total_bv');

        return (($resp * $config->leadership_perc) / 100) * ($config->usd_rate ?: 0);
    }

     public static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT ROUND(COUNT(`id`), 2) FROM `orders`) AS total_orders,
                (SELECT ROUND(COUNT(`id`), 2) FROM `orders` WHERE `status`='delivered' ) AS total_delivered,
                (SELECT ROUND(COUNT(`id`), 2) FROM `orders` WHERE `status`='pending' ) AS total_pending,
                (SELECT ROUND(COUNT(`id`), 2) FROM `orders` WHERE `status`='shipped' ) AS total_shipped,

                (SELECT ROUND(COUNT(`id`), 2) FROM `products`) AS total_products,
                (SELECT ROUND(SUM(`total`), 2) FROM `orders`) AS total_order_amount,
                (SELECT ROUND(SUM(`total_bv`), 2) FROM `orders`) AS total_order_bv,

                (SELECT SUM(`quantity`) FROM `orders`) AS products_sold,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders` WHERE status='delivered'
                ) AS total_order_delivered_amount,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders` WHERE status='delivered'
                ) AS total_order_delivered_bv,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders` WHERE status='pending'
                ) AS total_order_pending_amount,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders` WHERE status='pending'
                ) AS total_order_pending_bv,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders` WHERE status='shipped'
                ) AS total_order_shipped_amount,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders` WHERE status='shipped'
                ) AS total_order_shipped_bv,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE `created_at` >= CURDATE() AND `created_at` < CURDATE() + INTERVAL 1 DAY
                ) AS total_order_amount_today,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders`
                    WHERE `created_at` >= CURDATE() AND `created_at` < CURDATE() + INTERVAL 1 DAY
                ) AS total_order_bv_today,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE (YEARWEEK(`created_at`) = YEARWEEK(CURDATE()))
                ) AS total_order_amount_week,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders`
                    WHERE (YEARWEEK(`created_at`) = YEARWEEK(CURDATE()))
                ) AS total_order_bv_week,

                (SELECT
                    ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())
                ) AS total_order_amount_month,
                (SELECT
                    ROUND(SUM(`total_bv`), 2)
                    FROM `orders`
                    WHERE MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())
                ) AS total_order_bv_month,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE (YEAR(`created_at`) = YEAR(CURDATE()))
                ) AS total_order_amount_year,
                (SELECT ROUND(SUM(`total_bv`), 2)
                    FROM `orders`
                    WHERE (YEAR(`created_at`) = YEAR(CURDATE()))
                ) AS total_order_bv_year,


                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders` WHERE type='maintenance'
                ) AS total_activation_order,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE type='maintenance' AND
                    `created_at` >= CURDATE() AND `created_at` < CURDATE() + INTERVAL 1 DAY
                ) AS total_activation_today,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE type='maintenance' AND (YEARWEEK(`created_at`) = YEARWEEK(CURDATE()))
                ) AS total_activation_week,

                (SELECT
                    ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE type='maintenance' AND MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())
                ) AS total_activation_month,

                (SELECT ROUND(SUM(`total`), 2)
                    FROM `orders`
                    WHERE type='maintenance' AND (YEAR(`created_at`) = YEAR(CURDATE()))
                ) AS total_activation_year
            "
        )[0];
    }
}
