<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\DB;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'username',
        'comission',
        'rank',
        'rank_id',
        'referral',
        'placement',
        'placement_temp',
        'position',
        'binarity',
        'auto_placement',
        'first_member',
        'unilevel_activation_tracker',
        'status',
        'first_name',
        'last_name',
        'photo',
        'email',
        'email_code',
        'email_code_expire_time',
        'email_verified_at',
        'password',
        'registration_fee',
        'registration_fee_date',
        'next_due_date',
        'phone',
        'phone_code',
        'phone_verified_at',
        'dob',
        'gender',
        'city',
        'state',
        'zip',
        'country',
        'address',
        'signup_ip',
        'lastseen_ip',
        'lastseen_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'lastseen_at' => 'datetime',
        'registration_fee_date' => 'datetime',
        'password' => 'hashed',
    ];
    public function fullname()
    {
        return $this->first_name . " " . $this->last_name;
    }
 
   

 

    static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT COUNT(`id`) FROM `users`) AS total_invitees,
                (SELECT COUNT(`id`) FROM `users` WHERE status=1 ) AS approved_invitees,
                (SELECT COUNT(`id`) FROM `users` WHERE status=0) AS pending_invitees,
            "
        )[0];
    }

}
