<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Order;
use App\Models\AdminLog;
use Illuminate\Support\Facades\Auth;

class OrderService
{
    public static function allOrders($take)
    {
        return Order::with('user')->latest('id')->paginate($take ?: 20);
    }
    public static function ordersByStatus($status, $take)
    {
        return Order::with('user')->where('status', $status)->paginate($take ?: 20);
    }
    public static function getUserOrder($id, $take)
    {
        return Order::where('user_id', $id)->paginate($take ?: 20);
    }
   
    public static function showSingle($id)
    {
        $order = Order::find($id);
        return $order;
    }

    public static function trackOrder($number)
    {
        return Order::where('order_number', $number)->first();
    }

    public static function updateStatus($id)
    {
        $order = Order::find($id);
        $order->update([
            'status' => 'delivered',
            'delivery_date' => Carbon::now()->toDateTimeString()
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $order->id,
            'orders',
            ucfirst(Auth::user()->username).' Updated Order Status to delivered'
        );
    }

    static function autoshipChecker($userID, $isPreviousMonth=false)
    {
        if ($isPreviousMonth) {
            $month = sprintf("%02d", (now()->month - 1));
            $previousMonth = Carbon::now()->subMonth()->year.'-'.$month;
            $order = Order::where('created_at', 'like', '%'.$previousMonth.'%')
                ->where('user_id', $userID)
                ->count();
        }
        else {
            $order = Order::where('created_at', 'LIKE', '%'.date('Y').'-'.date('m').'%')
                ->where('user_id', $userID)
                ->count();
        }

        if ($order > 0) {
            return true;
        }

        return false;
    }
}
