<?php

namespace App\Services;

use App\Models\AboutUs;
use App\Models\Privacy;
use App\Models\AdminLog;
use App\Models\HomePage;
use App\Models\Configuration;
use App\Models\DistributorPage;
use App\Models\WebsiteSetting;
use App\Models\TermsAndCondition;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SettingsService
{
    public static function gethomePageDetails()
    {
        return HomePage::first();
    }
    public static function getDistributorPageDetails()
    {
        return DistributorPage::first();
    }
    public static function getConfigDetails()
    {
        return Configuration::first();
    }
    public static function getAboutUsDetails()
    {
        return AboutUs::first();
    }
    public static function getSiteDetails()
    {
        return WebsiteSetting::first();
    }
    public static function updateAboutPage($data)
    {
        $about_content = AboutUs::first();
        if ($data->hero_banner) {
            if (File::exists(public_path($about_content->hero_banner))) {
                File::delete(public_path($about_content->hero_banner));
            }
            $fileName = 'hero_banner' . '_' . time() . '.' . $data->hero_banner->getClientOriginalExtension();
            $hero_banner = UploadService::upload($data->hero_banner, 'about', $fileName);
        }
        if ($data->ceo_signature) {
            if (File::exists(public_path($about_content->ceo_signature))) {
                File::delete(public_path($about_content->ceo_signature));
            }
            $fileName = 'ceo_signature' . '_' . time() . '.' . $data->ceo_signature->getClientOriginalExtension();
            $ceo_signature = UploadService::upload($data->ceo_signature, 'about', $fileName);
        }
        if ($data->history_image) {
            if (File::exists(public_path($about_content->history_image))) {
                File::delete(public_path($about_content->history_image));
            }
            $fileName = 'history_image' . '_' . time() . '.' . $data->history_image->getClientOriginalExtension();
            $history_image = UploadService::upload($data->history_image, 'about', $fileName);
        }

        if ($data->support_image_one) {
            if (File::exists(public_path($about_content->support_image_one))) {
                File::delete(public_path($about_content->support_image_one));
            }
            $fileName = 'support_image_one' . '_' . time() . '.' . $data->support_image_one->getClientOriginalExtension();
            $support_image_one = UploadService::upload($data->support_image_one, 'about', $fileName);
        }
        if ($data->support_image_two) {
            if (File::exists(public_path($about_content->support_image_two))) {
                File::delete(public_path($about_content->support_image_two));
            }
            $fileName = 'support_image_two' . '_' . time() . '.' . $data->support_image_two->getClientOriginalExtension();
            $support_image_two = UploadService::upload($data->support_image_two, 'about', $fileName);
        }

        $about_content->update([
            'hero_banner'  => $data->hero_banner ? $hero_banner : $about_content->hero_banner,
            'hero_heading'  => $data->hero_heading,
            'hero_text' => $data->hero_text,
            'history_text' => $data->history_text,
            'ceo_signature' => $data->ceo_signature ? $ceo_signature : $about_content->ceo_signature,
            'ceo_name' => $data->ceo_name,
            'history_image' => $data->history_image ? $history_image : $about_content->history_image,
            'benefit_heading_one' => $data->benefit_heading_one,
            'benefit_heading_two' => $data->benefit_heading_two,
            'benefit_heading_three' => $data->benefit_heading_three,
            'benefit_heading_four' => $data->benefit_heading_four,
            'benefit_heading_five' => $data->benefit_heading_five,
            'benefit_heading_six' => $data->benefit_heading_six,
            'benefit_text_one' => $data->benefit_text_one,
            'benefit_text_two' => $data->benefit_text_two,
            'benefit_text_three' => $data->benefit_text_three,
            'benefit_text_four' => $data->benefit_text_four,
            'benefit_text_five' => $data->benefit_text_five,
            'benefit_text_six' => $data->benefit_text_six,
            'product_sold' => $data->product_sold,
            'reseller' => $data->reseller,
            'customer' => $data->customer,
            'support_image_one' => $data->support_image_one ? $support_image_one : $about_content->support_image_one,
            'support_image_two' => $data->support_image_two ? $support_image_two : $about_content->support_image_two,
            'support_heading_one' => $data->support_heading_one,
            'support_subheading_one' => $data->support_subheading_one,
            'support_text_one' => $data->support_text_one,
            'support_heading_two' => $data->support_heading_two,
            'support_subheading_two' => $data->support_subheading_two,
            'support_text_two' => $data->support_text_two,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $about_content->id,
            'about_us',
            ucfirst(Auth::user()->username) . 'Updated Website Details'
        );
    }
    public static function updateDistributorPage($data)
    {

        $distributor_content = DistributorPage::first();
        if ($data->hero_banner) {
            if (File::exists(public_path($distributor_content->hero_banner))) {
                File::delete(public_path($distributor_content->hero_banner));
            }
            $fileName = 'hero_banner' . '_' . time() . '.' . $data->hero_banner->getClientOriginalExtension();
            $hero_banner = UploadService::upload($data->hero_banner, 'home', $fileName);
        }

        if ($data->second_section_banner) {
            if (File::exists(public_path($distributor_content->second_section_banner))) {
                File::delete(public_path($distributor_content->second_section_banner));
            }
            $fileName = 'second_section_banner' . '_' . time() . '.' . $data->second_section_banner->getClientOriginalExtension();
            $second_section_banner = UploadService::upload($data->second_section_banner, 'home', $fileName);
        }


        $distributor_content->update([
            'hero_heading' => $data->hero_heading,
            'hero_text' => $data->hero_text,
            'first_section_heading_one' => $data->first_section_heading_one,
            'first_section_heading_two' => $data->first_section_heading_two,
            'first_section_heading_three' => $data->first_section_heading_three,
            'second_section_heading' => $data->second_section_heading,
            'first_section_text_one' => $data->first_section_text_one,
            'first_section_text_two' => $data->first_section_text_two,
            'first_section_text_three' => $data->first_section_text_three,
            'second_section_text' => $data->second_section_text,
            'hero_banner' => $data->hero_banner ? $hero_banner : $distributor_content->hero_banner,
            'second_section_banner' => $data->second_section_banner ? $second_section_banner : $distributor_content->second_section_banner,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $distributor_content->id,
            'distributor_pages',
            ucfirst(Auth::user()->username) . 'Updated Website Home page Details'
        );
    }

    public static function updatehomePage($data)
    {

        $home_content = HomePage::first();
        if ($data->hero_banner) {
            if (File::exists(public_path($home_content->hero_banner))) {
                File::delete(public_path($home_content->hero_banner));
            }
            $fileName = 'hero_banner' . '_' . time() . '.' . $data->hero_banner->getClientOriginalExtension();
            $hero_banner = UploadService::upload($data->hero_banner, 'home', $fileName);
        }
        if ($data->first_section_banner) {
            if (File::exists(public_path($home_content->first_section_banner))) {
                File::delete(public_path($home_content->first_section_banner));
            }
            $fileName = 'first_section_banner' . '_' . time() . '.' . $data->first_section_banner->getClientOriginalExtension();
            $first_section_banner = UploadService::upload($data->first_section_banner, 'home', $fileName);
        }
        if ($data->second_section_banner) {
            if (File::exists(public_path($home_content->second_section_banner))) {
                File::delete(public_path($home_content->second_section_banner));
            }
            $fileName = 'second_section_banner' . '_' . time() . '.' . $data->second_section_banner->getClientOriginalExtension();
            $second_section_banner = UploadService::upload($data->second_section_banner, 'home', $fileName);
        }

        if ($data->third_section_banner) {
            if (File::exists(public_path($home_content->third_section_banner))) {
                File::delete(public_path($home_content->third_section_banner));
            }
            $fileName = 'third_section_banner' . '_' . time() . '.' . $data->third_section_banner->getClientOriginalExtension();
            $third_section_banner = UploadService::upload($data->third_section_banner, 'home', $fileName);
        }
        if ($data->fourth_section_banner) {
            if (File::exists(public_path($home_content->fourth_section_banner))) {
                File::delete(public_path($home_content->fourth_section_banner));
            }
            $fileName = 'fourth_section_banner' . '_' . time() . '.' . $data->fourth_section_banner->getClientOriginalExtension();
            $fourth_section_banner = UploadService::upload($data->fourth_section_banner, 'home', $fileName);
        }
        if ($data->fifth_section_banner) {
            if (File::exists(public_path($home_content->fifth_section_banner))) {
                File::delete(public_path($home_content->fifth_section_banner));
            }
            $fileName = 'fifth_section_banner' . '_' . time() . '.' . $data->fifth_section_banner->getClientOriginalExtension();
            $fifth_section_banner = UploadService::upload($data->fifth_section_banner, 'home', $fileName);
        }
        $home_content->update([
            'hero_heading' => $data->hero_heading,
            'hero_text' => $data->hero_text,
            'first_section_heading' => $data->first_section_heading,
            'second_section_heading' => $data->second_section_heading,
            'third_section_heading' => $data->third_section_heading,
            'fourth_section_heading' => $data->fourth_section_heading,
            'fifth_section_heading' => $data->fifth_section_heading,
            'first_section_text' => $data->first_section_text,
            'second_section_text' => $data->second_section_text,
            'third_section_text' => $data->third_section_text,
            'fourth_section_text' => $data->fourth_section_text,
            'fifth_section_text' => $data->fifth_section_text,
            'hero_banner' => $data->hero_banner ? $hero_banner : $home_content->hero_banner,
            'first_section_banner' => $data->first_section_banner ? $first_section_banner : $home_content->first_section_banner,
            'second_section_banner' => $data->second_section_banner ? $second_section_banner : $home_content->second_section_banner,
            'third_section_banner' => $data->third_section_banner ? $third_section_banner : $home_content->third_section_banner,
            'fourth_section_banner' => $data->fourth_section_banner ? $fourth_section_banner : $home_content->fourth_section_banner,
            'fifth_section_banner' => $data->fifth_section_banner ? $fifth_section_banner : $home_content->fifth_section_banner,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $home_content->id,
            'home_pages',
            ucfirst(Auth::user()->username) . 'Updated Website Home page Details'
        );
    }
    public static function updateConfig($data)
    {
        $config = Configuration::first();
        $config->update([
            'child_reg_fee' => $data->child_reg_fee,
            'adult_reg_fee' => $data->adult_reg_fee,
            'student_reg_fee' => $data->student_reg_fee,
            'acct_name' => $data->acct_name,
            'acct_number' => $data->acct_number,
            'bank' => $data->bank,
        ]);
        // AdminLog::createAdminLog(
        //     Auth::user()->id,
        //     $config->id,
        //     'configurations',
        //     ucfirst(Auth::user()->username) . ' Updated Configuration Setting'
        // );
    }
    public static function updateWebsite($data)
    {

        $site_setting = WebsiteSetting::first();
        $site_setting->update([
            'business_name' => $data->business_name,
            'name' => $data->name,
            'logo_url' => $site_setting->logo_url,
            'favicon_url' => $site_setting->favicon_url,
            'dashboard_logo_url' => $site_setting->dashboard_logo_url,
            'business_address' => $data->business_address,
            'business_phone' => $data->business_phone,
            'business_email' => $data->business_email,
        ]);
        // AdminLog::createAdminLog(
        //     Auth::user()->id,
        //     $site_setting->id,
        //     'website_settings',
        //     ucfirst(Auth::user()->username) . ' Updated Website Details'
        // );
    }
    public static function updateSiteLogo($logo)
    {
        $site_setting = WebsiteSetting::first();
        if (File::exists(public_path($site_setting->logo_url))) {
            File::delete(public_path($site_setting->logo_url));
        }
        $fileName = str_replace(' ', '-', $logo->getClientOriginalName()) . '_' . time() . '.' . $logo->getClientOriginalExtension();
        $img_url = UploadService::upload($logo, 'Logo', $fileName);

        $site_setting->update([
            'logo_url' => $img_url,
        ]);

    }
    public static function updateSiteFavicon($favicon_url)
    {
        $site_setting = WebsiteSetting::first();
        if (File::exists(public_path($site_setting->favicon_url))) {
            File::delete(public_path($site_setting->favicon_url));
        }
        $fileName = str_replace(' ', '-', $favicon_url->getClientOriginalName()) . '_' . time() . '.' . $favicon_url->getClientOriginalExtension();
        $img_url = UploadService::upload($favicon_url, 'Favicon', $fileName);

        $site_setting->update([
            'favicon_url' => $img_url,
        ]);

    }
    public static function updateDasboardLogo($dashboard_logo)
    {
        $site_setting = WebsiteSetting::first();
        if (File::exists(public_path($site_setting->dashboard_logo_url))) {
            File::delete(public_path($site_setting->dashboard_logo_url));
        }
        $fileName = str_replace(' ', '-', $dashboard_logo->getClientOriginalName()) . '_' . time() . '.' . $dashboard_logo->getClientOriginalExtension();
        $img_url = UploadService::upload($dashboard_logo, 'dashboardLogo', $fileName);

        $site_setting->update([
            'dashboard_logo_url' => $img_url,
        ]);

    }


    public static function getPrivacyDetails()
    {
        return Privacy::first();
    }
    public static function getTermsDetails()
    {
        return TermsAndCondition::first();
    }
    public static function updateTermsAndCondition($data)
    {
        $terms = TermsAndCondition::first();
        if ($terms) {
            $terms->update([
                "title" => $data->title,
                "content" => $data->content,
            ]);
        } else {
            $terms = TermsAndCondition::create([
                "title" => $data->title,
                "content" => $data->content,
            ]);
        }
        AdminLog::createAdminLog(
            Auth::user()->id,
            $terms->id,
            'terms_and_conditions',
            ucfirst(Auth::user()->username) . ' Updated terms and conditions'
        );
    }
    public static function updatePrivacy($data)
    {
        $privacy = Privacy::first();
        if ($privacy) {
            $privacy->update([
                "title" => $data->title,
                "content" => $data->content,
            ]);
        } else {
            $privacy = Privacy::create([
                "title" => $data->title,
                "content" => $data->content,
            ]);
        }

        AdminLog::createAdminLog(
            Auth::user()->id,
            $privacy->id,
            'privacies',
            ucfirst(Auth::user()->username) . ' Updated Privacy details'
        );
    }
}
