<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username')->unique();
            $table->string('rank')->nullable()->comment('current rank');
            $table->integer('rank_id')->nullable();
            $table->string('referral')->nullable();
            $table->double('comission')->default(0);
            $table->string('placement')->nullable();
            $table->string('placement_temp')->nullable()->comment('Temp. holder for none Reg. fee payment');
            $table->enum('position', ['left', 'right'])->nullable();
            $table->integer('binarity')->default(0)->comment('Sponsor at least 2 & 1 in each binary legs team	');
            $table->enum('auto_placement', ['far_left','far_right','full_left','full_right','even'])->default('even');
            $table->enum('first_member', ['left','right'])->default('left');
            $table->enum('status', ['Active', 'Pending', 'Suspended', 'Blocked'])->default('Pending');
            $table->enum('activity_status', ['active', 'inactive'])->default('inactive');
            $table->integer('unilevel_activation_tracker')->default(0)->comment('Count 1-3, start again');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('photo')->nullable();
            $table->string('email')->nullable();
            $table->string('email_code')->nullable();
            $table->dateTime('email_code_expire_time')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->integer('registration_fee')->default(0)->comment('1 => paid, 0 => unpaid');
            $table->timestamp('registration_fee_date')->nullable()->comment('date paid');
            $table->timestamp('next_due_date')->nullable()->comment('Next reg.date');
            $table->string('phone')->nullable();
            $table->string('phone_code')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->string('dob')->nullable();
            $table->string('gender')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->string('country')->nullable();
            $table->string('address')->nullable();
            $table->string('signup_ip')->nullable();
            $table->string('lastseen_ip')->nullable();
            $table->timestamp('lastseen_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
