@extends('layouts.admin')
@section('title','Login Activities Manager')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Login Activities Manager</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Login Activities Manager
                        </li>
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.epins.create')}}" role="button">
                        <i class="bi bi-plus-circle"></i>
                        New Code
                    </a>

                </div>
            </div> --}}
        </div>
    </div>

    
    <div class="card-box pb-10">            
        <div class="card-tools float-right py-2 px-3">
            <form action="{{request()->url()}}" method="GET">
                <div class="input-group input-group-sm" style="width: 150px;">
                    <select name="take" class="form-control" onchange="this.form.submit()">
                        <option value="">-- per Page --</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                        <option value="150">150</option>
                    </select>
                </div>
            </form>
        </div>
        <table class="table nowrap">
            <thead>
                <tr>
                    <th>Admin</th>
                    <th>IP</th>
                    <th>OS</th>
                    <th>Browser</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($adminLogins as $adminLogin)
                <tr>
                    <td>{{ucfirst($adminLogin->admin->username)}}</td>
                    <td>{{$adminLogin->ip_address}}</td>
                    <td>{{ucfirst($adminLogin->os)}}</td>
                    <td>{{ucfirst($adminLogin->browser)}}</td>
                    <td>
                        <x-date-format :date="$adminLogin->created_at" />
                    </td>
                </tr>
                @empty
                <table>
                    <tr>
                        <p class="text-center">No record found</p>
                    </tr>
                </table>
                @endforelse

            </tbody>
        </table>
        <div class="px-3">{{$adminLogins->withQueryString()->links()}}</div>
    </div>
</div>

@endsection
