@extends('layouts.admin')
@section('title','Sub-admin Manager')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Admin Manager</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                           Sub Admins
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a
                        class="btn btn-primary"
                        href="{{route('admin.admins.create')}}"
                        role="button"
                    >
                    <i class="bi bi-plus-circle"></i>
                       New
                    </a>
                 
                </div>
            </div>
        </div>
    </div>
    <div class="card-box pb-10">
        <div class="h5 pd-20 mb-0"></div>
        @if (session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{session('message')}}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif
        <table class="table nowrap">
            <thead>
                <tr>
                    <th class="table-plus">Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Date</th>
                    <th class="datatable-nosort">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($admins as $admin)
                <tr>                    
                    <td>{{$admin->fullname() ? ucfirst($admin->fullname()) : ucfirst($admin->username)}}</td>
                    <td>{{$admin->email}}</td>
                    <td>{{$admin->phone}}</td>
                    <td><x-date-format :date="$admin->created_at" /></td>
                   
                    <td>
                        <div class="table-actions">
                            <form action="{{route('admin.admins.destroy',$admin->id)}}" method="POST">
                                <a href="{{route('admin.admins.show',$admin->id)}}" data-color="#265ed7"><i class="icon-copy dw dw-edit2"></i></a>
                             
                                @csrf
                                @method('DELETE')
                                <button type="submit" data-color="#e95959" onclick="return confirm('Continue With Delete?')"
                                    class="btn" title="Delete admin"><i class="icon-copy dw dw-delete-3"></i></button>
                            </form>
                            {{-- <a href="#" data-color="#e95959"><i class="icon-copy dw dw-delete-3"></i></a> --}}
                        </div>
                    </td>
                </tr>
                @empty
                    <table>
                        <tr>
                            <p class="text-center">No record found</p>
                        </tr>
                    </table>
                @endforelse
              
                
            </tbody>
        </table>
        <div class="px-3">{{$admins->links()}}</div>
    </div>
</div>

@endsection