@extends('layouts.auth.admin')
@section('title','Admin Login')
@section('content')
<div class="login-wrap d-flex align-items-center flex-wrap justify-content-center">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 col-lg-7">
                <img src="{{asset('admin-ui/vendors/images/login-page-img.png')}}" alt="" />
            </div>
            <div class="col-md-6 col-lg-5">
                <div class="login-box bg-white box-shadow border-radius-10">
                    <div class="login-title">
                        <h2 class="text-center text-primary">Administrators Only</h2>
                        <div class="row alert alert-success pt-3" id="successBox" style="display: none" role="alert">
                            <div class="col-md-12" id="successMessage"></div>
                        </div>
                        <div class="row alert alert-danger pt-3" id="errorBox" style="display: none" role="alert">
                            <div class="col-md-12" id="errorMessage"></div>
                        </div>
                    </div>
                    <form id="login-form" method="POST">
                        @csrf
                        {{-- <div class="select-role">
                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                <label class="btn active">
                                    <input type="radio" name="options" id="admin" />
                                    <div class="icon">
                                        <img src="{{asset('admin-ui/vendors/images/briefcase.svg')}}" class="svg" alt="" />
                                    </div>
                                    <span>I'm</span>
                                    Manager
                                </label>
                                <label class="btn">
                                    <input type="radio" name="options" id="user" />
                                    <div class="icon">
                                        <img src="{{asset('admin-ui/vendors/images/person.svg')}}" class="svg" alt="" />
                                    </div>
                                    <span>I'm</span>
                                    Employee
                                </label>
                            </div>
                        </div> --}}
                        <div class="input-group custom">
                            <input type="text" name="admin" id="admin" class="form-control form-control-lg" placeholder="Username / Email" />
                            <div class="input-group-append custom">
                                <span class="input-group-text"><i class="icon-copy dw dw-user1"></i>|<i class="icon-copy dw dw-email"></i></span>
                            </div>
                        </div>
                        <div class="input-group custom">
                            <input type="password" name="password" id="password" class="form-control form-control-lg" placeholder="**********" />
                            <div class="input-group-append custom">
                                <span class="input-group-text"><i class="dw dw-padlock1"></i></span>
                            </div>
                        </div>
                        <div class="row pb-30">
                            <div class="col-6">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="customCheck1" />
                                    <label class="custom-control-label" for="customCheck1">Remember</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="forgot-password">
                                    <a href="">Forgot Password</a>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="input-group mb-0">
                                    <!--
                                        use code for form submit
                                        <input class="btn btn-primary btn-lg btn-block" type="submit" value="Sign In">
                                    -->
                                    <button type="submit" class="btn btn-primary btn-lg btn-block">Sign In</button>
                                </div>
                                <div class="font-16 weight-600 pt-10 pb-10 text-center" data-color="#707373">
                                    {{-- OR
                                </div>
                                <div class="input-group mb-0">
                                    <a class="btn btn-outline-primary btn-lg btn-block" href="register.html">Register To Create Account</a>
                                </div> --}}
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{asset('admin-ui/js/jquery.min.js')}}"></script>
<script>
    $('#login-form').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
            , type: 'POST'
            , url: "{{ route('adminLogin') }}"
            , data: formData
            , contentType: false
            , processData: false
            , success: (response) => {
                if (response.status == 'success') {
                    this.reset();
                    document.getElementById("successBox").style.display = 'block';
                    document.getElementById("successMessage").innerHTML = response.message;
                    setTimeout(function() {
                        Redirect();
                    }, 1000);
                }
                if (response.status == 'error') {
                    document.getElementById("errorBox").style.display = 'block';
                    document.getElementById("errorMessage").innerHTML = response.message;
                    setTimeout(function() {
                    reloadPage();
                }, 1000);
                }
            }
        , });
        function reloadPage() {
        window.location = "{{ route('showAdminLogin') }}";
    }
        function Redirect() {
            window.location = "{{ route('adminDashboard') }}";
        }
    });

</script>
@endsection
