@extends('layouts.admin')
@section('title', 'Chat')
@section('content')

    <div class="pd-ltr-20 xs-pd-20-10">
        <div class="min-height-200px">
            <div class="page-header">
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="title">
                            <h4>Chat</h4>
                        </div>
                        <nav aria-label="breadcrumb" role="navigation">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Chat</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="bg-white border-radius-4 box-shadow mb-30">
                <div class="row no-gutters">

                    @livewire('chat-u-i', ['user' => $user], key($user->id))
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="module">
        window.Echo.channel(`chat.${userId}`)
         .listen('chat', (e) => {
        console.log(e.order);
    });
    </script>
@endsection
