@extends('layouts.admin')
@section('title','Invitee Details')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Invitee Details</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            Invitees Manager
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                           Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('invitees')}}" role="button">
                        <i class="bi bi-plus-circle"></i>
                       Invitees
                    </a>

                </div>
            </div>
        </div>
    </div>

    <div class="card-box pb-10">
        <div class="h5 pd-20 mb-0"></div>
        @if (session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{session('message')}}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif
        <div class="row">
            <!-- left column -->
            <div class="col-md-8">
                <!-- general form elements -->
                <div class="card mx-3">
                    <div class="card-body">
                        <form>
                            @if (session('error'))
                                <p class="alert alert-danger" role="alert">
                                    {{ session('error') }}
                                </p>
                            @endif

                            <div class="form-group">
                                <label for="">First Name</label>
                                <input type="text" readonly name="first_name" class="form-control"
                                    value="{{ $invitee->first_name }}" placeholder="First Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Last Name</label>
                                <input type="text" readonly name="last_name" class="form-control" value="{{ $invitee->last_name }}"
                                    placeholder="Last Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Gender</label>
                                <select name="gender" disabled class="form-control" id="">
                                    <option value="{{$invitee->gender }}">{{$invitee->gender }}</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>

                            </div>
                            <div class="form-group">
                                <label for="">Email</label>
                                <input type="email" name="email" readonly class="form-control" value="{{ $invitee->email }}"
                                    placeholder="Email" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Contact</label>
                                <input type="text" name="phone" readonly class="form-control" value="{{ $invitee->phone }}"
                                    placeholder="Phone" id="">
                            </div>


                        </form>
                    </div>

                </div>
                <!-- /.card -->

            </div>
            <div class="col-md-4">
                <!-- general form elements -->
                <div class="card mx-3">
                    <div class="card-body">
                        @if (file_exists($invitee->profile_photo))
                        <div class="mb-3">
                            <img src="{{file_exists($invitee->profile_photo) ? asset($invitee->profile_photo) : 'N/A'}}" class="w-50 img-thumbnail" alt="{{$invitee->first_name}}" />
                        </div>
                        @endif
                        @if(strtolower($invitee->status) == 1)
                        <label for="status" class="form-label">
                            Status
                        </label>
                            <span class="btn btn-sm btn-success">Approved</span>
                        @else
                        <label for="status" class="form-label">
                            Status
                        </label>
                            <span class="btn btn-sm btn-secondary">Pending</span>
                            <br>
                        <label for="">Click to approve</label>
                        <form action="{{route('admin.approve-invitee', $invitee->id)}}" method="POST">
                            @csrf

                            <button type="submit" onclick="return confirm('Are you sure you want to approve this Invitee?')" class="btn btn-success btn-sm" title="Confirm Payment">Approve</button>
                        </form>

                        @endif


                    </div>

                </div>
                <!-- /.card -->

            </div>

        </div>

    </div>
</div>

@endsection
