@extends('layouts.admin')
@section('title','Configuration Setting')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Configuration Setting</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>

                        <li class="breadcrumb-item active" aria-current="page">
                            Configuration Setting
                        </li>
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.admins.index')}}" role="button">
            Admin Manager
            </a>

        </div>
    </div> --}}
</div>
</div>
<div class="row">
    <div class="col-md-10">
        <div class="pd-20 card-box mb-30">
            @if (session('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{session('message')}}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            <form role="form" action="{{route('admin.config-update')}}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Child Registeration Fee </label>
                                <input type="number" value="{{$config_content->child_reg_fee	}}" class="form-control" name="child_reg_fee">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Child Registeration Fee</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Student Registeration Fee </label>
                                <input type="number" value="{{$config_content->student_reg_fee	}}" class="form-control" name="student_reg_fee">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Student Registeration Fee</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Adult Registeration Fee </label>
                                <input type="number" value="{{$config_content->adult_reg_fee	}}" class="form-control" name="adult_reg_fee">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Adult Registeration Fee</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Account Name </label>
                                <input type="text" value="{{$config_content->acct_name}}" class="form-control" name="acct_name">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Account Name</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Account Number </label>
                                <input type="text" value="{{$config_content->acct_number}}" class="form-control" name="acct_number">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Account Number</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Bank </label>
                                <input type="text" value="{{$config_content->bank}}" class="form-control" name="bank">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <p class="pt-4">Bank </p>
                        </div>
                    </div>

                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update Setting</button>
                </div>
            </form>


        </div>
    </div>

</div>
</div>

@endsection
