<!DOCTYPE html>
<html>
<head>
    <!-- Basic Page Info -->
    <meta charset="utf-8" />
    <title>@yield('title') - Admin | Camp Meeting</title>

    <!-- Site favicon -->
    <x-site-favicon />
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet" />
    <!-- CSS -->
    <link rel="stylesheet" type="text/css" href="{{asset('admin-ui/vendors/styles/core.css')}}" />
    <link rel="stylesheet" type="text/css" href="{{asset('admin-ui/vendors/styles/icon-font.min.css')}}" />
    <link rel="stylesheet" type="text/css" href="{{asset('admin-ui/src/plugins/datatables/css/dataTables.bootstrap4.min.css')}}" />
    <link rel="stylesheet" type="text/css" href="{{asset('admin-ui/src/plugins/datatables/css/responsive.bootstrap4.min.css')}}" />
    <link rel="stylesheet" type="text/css" href="{{asset('admin-ui/vendors/styles/style.css')}}" />

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-GBZ3SGGX85"></script>
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-2973766580778258" crossorigin="anonymous"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag("js", new Date());

        gtag("config", "G-GBZ3SGGX85");

    </script>
    <!-- Google Tag Manager -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                "gtm.start": new Date().getTime()
                , event: "gtm.js"
            });
            var f = d.getElementsByTagName(s)[0]
                , j = d.createElement(s)
                , dl = l != "dataLayer" ? "&l=" + l : "";
            j.async = true;
            j.src = "https://www.googletagmanager.com/gtm.js?id=" + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, "script", "dataLayer", "GTM-NXZMQSS");

    </script>
    <!-- End Google Tag Manager -->
    <style>
        .alert-danger {
            color: #fff;
            background-color: #dc3545 !important;
            border-color: #f5c2c7
        }

        .alert-success {
            background-color: #06a15b !important;
            border-color: #06a15b;
            color: #fff;
        }

        .sidebar-menu>ul>li>.dropdown-toggle.active {
            color: #fff;
            background-color: #1b00ff;
            border-color: #1b00ff;
        }

    </style>
    @yield('script')
</head>
<body>
    <x-admin-header />
    <x-admin-side-menu />

    <div class="main-container">
        <div class="xs-pd-20-10 pd-ltr-20">
            @yield('content')
            <div class="title pb-20 pt-20"></div>
            <x-admin-footer/>
        </div>
    </div>

    <!-- js -->
    <script src="{{asset('admin-ui/vendors/scripts/core.js')}}"></script>
    <script src="{{asset('admin-ui/vendors/scripts/script.min.js')}}"></script>
    <script src="{{asset('admin-ui/vendors/scripts/process.js')}}"></script>
    <script src="{{asset('admin-ui/vendors/scripts/layout-settings.js')}}"></script>
    <script src="{{asset('admin-ui/src/plugins/apexcharts/apexcharts.min.js')}}"></script>
    <script src="{{asset('admin-ui/src/plugins/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin-ui/src/plugins/datatables/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('admin-ui/src/plugins/datatables/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin-ui/src/plugins/datatables/js/responsive.bootstrap4.min.js')}}"></script>
    <script src="{{asset('admin-ui/vendors/scripts/dashboard3.js')}}"></script>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NXZMQSS" height="0" width="0" style="display: none; visibility: hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

</body>
</html>
