@extends('layouts.auth.user')
@section('title', 'Invitee details')
@section('content')
    <div class="limiter">
        <div class="container-login100">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10 mb-3">
                    <p class="text-center mb-3"><x-site-logo /></p>
                    <div class="wrap-login100">
                        <form class="login100-form" method="POST" action="{{ route('payment-onlineInvitee') }}">
                            <h4 class="text-center mb-3 fw-bold">Online Registration</h4>
                            @csrf
                            @if (session('error'))
                                <p class="alert alert-danger" role="alert">
                                    {{ session('error') }}
                                </p>
                            @endif
                            <div class="form-group py-3">

                                <input type="hidden" name="reg_type" value="online">

                                <div class="form-group">
                                    <input class="form-control" required type="text" name="name"
                                        placeholder="full Name">
                                    @error('full_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group py-2">
                                    <select name="reg_category" required class="form-control" id="">
                                        <option value="">-- Select Registration Category --</option>
                                        <option value="Children">Children ₦2,000</option>
                                        <option value="Teenager">Teenager ₦4,000</option>
                                        <option value="Adult">Adult ₦7,000</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <input class="form-control required type="email" name="email" placeholder="Email Only">

                                </div>
                                <div class="form-group">
                                    <input class="form-control" required type="text" maxlength="11" name="phone"
                                        placeholder="Phone number / Whatsapp eg 090...">

                                </div>
                                <div class="form-group py-2">
                                    <select name="gender" required class="form-control" id="">
                                        <option value="">-- Gender --</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                    </select>
                                </div>
                            </div>
                            <div class="container-login100-form-btn">
                                <button type="submit" class="login100-form-btn">
                                    Register
                                </button>
                            </div>
                            {{-- <button type="button" class="btn btn-success" onclick="makePayment()">Pay Now</button> --}}

                        </form>
                    </div>
                </div>
                <div class="col-md-1"></div>
            </div>
        </div>
    </div>

    {{-- <script src="{{ asset('AdminAuth/js/jquery.min.js') }}"></script> --}}
    <script src="https://checkout.flutterwave.com/v3.js"></script>
    {{-- <script type='text/javascript'>
        $(document).ready(function() {
            var maxField = 6; //Input fields increment limitation
            var addTestimonial = $('.add_testimonial'); //Add button selector
            var testimonial_wrapper = $('.testimonial_wrapper'); //Input field wrapper

            var TestimonialgHTML =
                '<div class="form-group"><label>Full Name</label><input class="form-control" type="text" name="first_name[]" placeholder="Full Name"> <label>Category</label> <select name="reg_category2[]" class="input100 form-control" id=""><option value="">-- Select Registration Category --</option><option value="Children">Children ₦2,000</option><option value="Teenager">Teenager ₦4,000</option><option value="Adult">Adult ₦7,000</option></select><div class="form-group"><label>Phone</label><input class="form-control" type="text" name="phone2[]" placeholder="Phone Number (Whatsapp"><label>Email</label><input class="form-control" type="email" name="email2[]" placeholder="Email (Optional)"><a href="javascript:void(0);" class="remove_testimonial btn-danger btn-sm text-white"><i class="fa fa-times py-3"></i></a></div>';
            var x = 1; //Initial field counter is 1

            $(addTestimonial).click(function() {
                //Check maximum number of input fields
                if (x < maxField) {
                    x++; //Increment field counter
                    $(testimonial_wrapper).append(TestimonialgHTML); //Add field html
                }
            });
            //Once remove button is clicked

            $(testimonial_wrapper).on('click', '.remove_testimonial', function(e) {
                e.preventDefault();
                $(this).parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
    </script> --}}

<script>
    function makePayment() {
	FlutterwaveCheckout({
		public_key: 'FLWPUBK_TEST-SANDBOXDEMOKEY-X',
		tx_ref: 'titanic-48981487343MDI0NzMx',
		amount: 600,
		currency: 'NGN',
		payment_options: 'card, mobilemoneyghana, ussd',
		redirect_url: 'https://glaciers.titanic.com/handle-flutterwave-payment',
		meta: {
			consumer_id: 23,
			consumer_mac: '92a3-912ba-1192a',
		},
		customer: {
			email: 'rose@unsinkableship.com',
			phone_number: '08102909304',
			name: 'Rose DeWitt Bukater',
		},
		customizations: {
			title: 'The Grace Trybe',
			description: 'Payment for Campmeeting 2025',
			logo: '',
		},
	});
}
</script>
    {{-- <script>
        $(document).ready(function() {
            $('#regType').on('change', function() {
                if (this.value == 'personal') {
                    $("#singleReg").show();
                    $("#sbtn").show();
                    $("#bulkReg").hide();
                }
                if (this.value == 'bulk') {
                    $("#bulkReg").show();
                    $("#sbtn").show();
                    $("#singleReg").hide();
                }
                if (this.value == '') {
                    $("#singleReg").hide();
                    $("#bulkReg").hide();
                    $("#sbtn").hide();
                }

            });
        });
    </script> --}}
@endsection
