<?php

namespace App\Http\Controllers\Admin;

use App\Models\Admin;
use Illuminate\Http\Request;
use App\Services\UploadService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Illuminate\Validation\Validator as ValidatorCustom;

class ProfileController extends Controller
{
    public function profile()
    {
        return view('admin.profile.index', [
            'admin' => Auth::guard('admin')->user()
        ]);
    }

    public function update(Request $request)
    {
        $admin = Admin::where('id',Auth::guard('admin')->user()->id)->first();
        if ($request->file('photo')) {
            if (File::exists(public_path($admin->photo))) {
                File::delete(public_path($admin->photo));
            }
            $fileName = str_replace(' ', '', $admin->username) . '_' . time() . '.' . $request->photo->getClientOriginalExtension();
            $img_url = UploadService::upload($request->photo, 'admins', $fileName);
        }
        $admin->update([
            'email' => $request->email,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone' => $request->phone,
            'photo' => $request->photo ? $img_url : $admin->photo,
            'address' => $request->address,
            'city' => $request->city,
            'state' => $request->state,
            'country' => $request->country,
            'bio' => $request->bio,
        ]);

        return redirect()->route('admin.profile')->with('message', 'Profile Updated successfully.');
    }

    public function showChangePassword()
    {
        $admin = Auth::guard('admin')->user();
        return view('admin.profile.password',compact('admin'));
    }

    public function changePassword(Request $request)
    {
        $admin = Auth::guard('admin')->user();

        $validate = Validator::make($request->all(), [
            'current_password' => 'required',
            'password' => ['required', 'confirmed', Password::min(6)]
        ]);

        $validate->after(function (ValidatorCustom $validator) use ($request, $admin) {
            if (!Hash::check($request->current_password, $admin->password)) {
                $validator->errors()->add(
                    'current_password',
                    'Your current password is incorrect!'
                );
            }
        });

        if ($validate->fails()) {
            return redirect()->route('admin.password')->withErrors($validate);
        }

        Admin::where('id', $admin->id)->update([
            'password' => Hash::make($request->password)
        ]);

        return redirect()
            ->route('admin.password')
            ->with('status', 'Password updated successfully.');
    }

    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect('administrator/login');
    }
}
