<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\TestimonialService;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    public function __construct(
        private TestimonialService $testimonialService
    ) {}
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $testimonies = $this->testimonialService->allTestimonials();
        return view('admin.testimonial.index', compact('testimonies'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.testimonial.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate(
            [
                'name' => 'required',
                'post' => 'required',
                'content' => 'required',
                'image' => 'nullable|image'
            ],
            [
                'image.nullable' => 'User Photo must be Image file'
            ]
        );
        $this->testimonialService->store($request);
        return redirect()->back()->with('message', 'New Testimonial Added Successfully!');
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $testimony = $this->testimonialService->edit($id);
        if (!$testimony) {
            abort(404);
        }
        return view('admin.testimonial.edit', compact('testimony'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $testimony = $this->testimonialService->edit($id);
        if (!$testimony) {
            abort(404);
        }
        $this->testimonialService->update($id, $request);
        return redirect()->back()->with('message', 'Details Updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $testimony = $this->testimonialService->edit($id);
        if (!$testimony) {
            abort(404);
        }
        $this->testimonialService->delete($id);
        return redirect()->back()->with('message', 'Testimony Details Deleted Successfully!');
    }
}
