<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\UserPaymentInformation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AddPaymentInforController extends Controller
{
    public function __construct()
    {
        // Check if personal detail is entered otherwise redirect to personal info page
    }

    function show() 
    {
        $user = Auth::user();
        if (!$user) {
            return redirect()->route('register');
        }
        if (!$user->first_name || !$user->last_name) {
            return redirect()->route('personal.show');
        }

        return view('auth.add-payment-info', ['user' => $user]);
    }

    function store(Request $request) 
    {
        $user = Auth::user();

        $request->validate([
            'account_name' => 'required',
            'account_number' => 'required',
            'bank_name' => 'required',
            'country' => 'required',
        ]);

       UserPaymentInformation::updateOrInsert(
        [
            'user_id' => $user->id
        ],
        [
            'account_name' => $request->account_name,
            'account_number' => $request->account_number,
            'bank_name' => $request->bank_name,
            'country' => $request->country,
        ]
       );

        return redirect()
            ->route('fee-payment.show')
            ->with('status', 'Payment information added successfully, next is the registration fee payment');
    }
}
