<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\RankQualification;
use Illuminate\Support\Facades\Auth;

class RankQualificationService
{
    public static function allRanks($take)
    {
        return RankQualification::oldest('id')->paginate($take ?: 20);
    }

    public static function store($data)
    {

        $rank = RankQualification::create([
            'level' => $data->level,
            'name' => $data->name,
            'pv' => $data->pv,
            'reward' => $data->reward,
        ]);

        AdminLog::createAdminLog(
            Auth::user()->id,
            $rank->id,
            'rank_qualifications',
            ucfirst(Auth::user()->username) . ' Added new Rank'
        );
    }
    public static function edit($id)
    {
        return RankQualification::find($id);
    }
    public static function update($id, $data)
    {

        $rank = RankQualification::find($id);
        $rank->update([
            'level' => $data->level,
            'name' => $data->name,
            'pv' => $data->pv,
            'reward' => $data->reward,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $rank->id,
            'rank_qualifications',
            ucfirst(Auth::user()->username) . ' Updated Rank Detials'
        );
    }
}
