<?php $__env->startSection('title','My Profile'); ?>
<?php $__env->startSection('content'); ?>
<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>My Profile</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('adminDashboard')); ?>">Admin</a>
                        </li>

                        <li class="breadcrumb-item active" aria-current="page">
                            Password
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right"> </div>
    </div>
</div>
<div class="row mb-10">
    <div class="col-md-12">
        <div class="card-box height-100-p overflow-hidden">
            <div class="profile-tab height-100-p">
                <div class="tab height-100-p">
                    <ul class="nav nav-tabs customtab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('admin.profile')); ?>" role="tab">Profile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="<?php echo e(route('admin.password')); ?>" role="tab">Password </a>
                        </li>

                    </ul>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 mb-30">
        <div class="pd-20 card-box height-100-p">
            <div class="profile-photo">
                <img src="<?php echo e(file_exists($admin->photo) ? asset($admin->photo) : asset('admin-ui/vendors/images/photo1.jpg')); ?>" alt="<?php echo e(ucfirst($admin->username)); ?>" class="avatar-photo" />
        
            </div>
            <h5 class="text-center h5 mb-0"><?php echo e(ucfirst($admin->username)); ?></h5>
            <p class="text-center text-muted font-14">
                <?php echo e(ucfirst($admin->role)); ?>

            </p>
            <div class="profile-info">
                <h5 class="mb-20 h5 text-blue">Contact Information</h5>
                <ul>
                    <li>
                        <span>Email Address:</span>
                        <?php echo e($admin->email); ?>

                    </li>
                    <li>
                        <span>Phone Number:</span>
                        <?php echo e($admin->phone); ?>

                    </li>
                    <li>
                        <span>Country:</span>
                        <?php echo e($admin->country); ?>

                    </li>
                    <li>
                        <span>Address:</span>
                        <?php echo e($admin->address); ?><br />
                        <?php echo e($admin->city.''); ?> <?php echo e($admin->state); ?>

                    </li>
                </ul>
            </div>
        
        </div>
    </div>
    <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12 mb-30">
        <div class="card-box height-100-p overflow-hidden">
            <div class="profile-tab height-100-p">
                <div class="tab height-100-p">
                    <div class="pd-20 card-box mb-30">
                        <?php if(session('status')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> <?php echo e(session('status')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>
                        <?php if($errors->any()): ?>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger alert-dismissible fade show my-2" role="alert">
                            <strong>Error!</strong> <?php echo e($error); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <form class="form-horizontal" action="<?php echo e(route('admin.password-update')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label>Current Password</label>
                                <input class="form-control" required placeholder="********" type="password" required name="current_password" />

                            </div>
                            <div class="form-group">
                                <label>New Password</label>
                                <input class="form-control" name="password" required type="password" placeholder="********" />

                            </div>
                            <div class="form-group">
                                <label>Confirm Password</label>
                                <input class="form-control" name="password_confirmation" placeholder="********" type="password" />
                            </div>
                          

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update Password</button>
                            </div>
                        </form>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/beconline/register.believerscampmeeting.com/resources/views/admin/profile/password.blade.php ENDPATH**/ ?>