<?php $__env->startSection('title', 'User Login'); ?>
<?php $__env->startSection('description', 'Login Page'); ?>

<?php $__env->startSection('content'); ?>
<div class="form-cont">
    <div class="form-title text-center">
        Login
    </div>
    <p class="alert alert-success mb-2" id="successBox" style="display: none">
        <strong class="text-white" id="successMessage"></strong>
    </p>
    <p class="alert alert-danger text-white" id="errorBox" style="display: none">
        <span class="text-white" id="errorMessage"></span>
    </p>
    <form id="login-form" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for=""> Username <span>*</span></label>
            <input type="text" name="username" id="username" placeholder="Username" class="form-control">
        </div>
        <div class="form-group">
            <label for="">Password <span>*</span></label>
            <input type="password" name="password" id="password" placeholder="Password" class="form-control">
        </div>
        <div class="form-flexed">
            <div class="remember-div"><input type="checkbox" /> Remember me</div>
            <div>
                <a href="<?php echo e(route('forgot-password.index')); ?>" class="forgot-password__link">Forgot Password?</a>
            </div>
        </div>
        <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve(['size' => 'large','label' => 'Login'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
        <div class="create-acc">
            A new member?
            <a href="<?php echo e(route('register')); ?>" class="text-decoration-underline text-secondary"> Create an account</a>
        </div>
    </form>
</div>
<script src="<?php echo e(asset('admin-ui/js/jquery.min.js')); ?>"></script>
<script>
    $('#login-form').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
            , type: 'POST'
            , url: "<?php echo e(route('login.process')); ?>"
            , data: formData
            , contentType: false
            , processData: false
            , success: (response) => {
                if (response.status == 'success') {
                    this.reset();
                    document.getElementById("successBox").style.display = 'block';
                    document.getElementById("successMessage").innerHTML = response.message;
                    setTimeout(function() {
                        Redirect();
                    }, 1000);
                }
                if (response.status == 'error') {
                    document.getElementById("errorBox").style.display = 'block';
                    document.getElementById("errorMessage").innerHTML = response.message;
                    setTimeout(function() {
                        reloadPage();
                    }, 2000);
                }
            }
        , });

        function reloadPage() {
            window.location = "<?php echo e(route('login')); ?>";
        }

        function Redirect() {
            window.location = "<?php echo e(route('dashboard')); ?>";
        }
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\HP\Documents\Training\event-app\resources\views/auth/login.blade.php ENDPATH**/ ?>