<?php $__env->startSection('title','Invitee Details'); ?>
<?php $__env->startSection('content'); ?>

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Invitee Details</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('adminDashboard')); ?>">Admin</a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page">
                            Invitees Manager
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                           Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="<?php echo e(route('invitees')); ?>" role="button">
                        <i class="bi bi-plus-circle"></i>
                       Invitees
                    </a>

                </div>
            </div>
        </div>
    </div>

    <div class="card-box pb-10">
        <div class="h5 pd-20 mb-0"></div>
        <?php if(session('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?php echo e(session('message')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <?php endif; ?>
        <div class="row">
            <!-- left column -->
            <div class="col-md-8">
                <!-- general form elements -->
                <div class="card mx-3">
                    <div class="card-body">
                        <form>
                            <?php if(session('error')): ?>
                                <p class="alert alert-danger" role="alert">
                                    <?php echo e(session('error')); ?>

                                </p>
                            <?php endif; ?>

                            <div class="form-group">
                                <label for="">First Name</label>
                                <input type="text" readonly name="first_name" class="form-control"
                                    value="<?php echo e($invitee->first_name); ?>" placeholder="First Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Last Name</label>
                                <input type="text" readonly name="last_name" class="form-control" value="<?php echo e($invitee->last_name); ?>"
                                    placeholder="Last Name" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Gender</label>
                                <select name="gender" disabled class="form-control" id="">
                                    <option value="<?php echo e($invitee->gender); ?>"><?php echo e($invitee->gender); ?></option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>

                            </div>
                            <div class="form-group">
                                <label for="">Email</label>
                                <input type="email" name="email" readonly class="form-control" value="<?php echo e($invitee->email); ?>"
                                    placeholder="Email" id="">
                            </div>
                            <div class="form-group">
                                <label for="">Contact</label>
                                <input type="text" name="phone" readonly class="form-control" value="<?php echo e($invitee->phone); ?>"
                                    placeholder="Phone" id="">
                            </div>


                        </form>
                    </div>

                </div>
                <!-- /.card -->

            </div>
            <div class="col-md-4">
                <!-- general form elements -->
                <div class="card mx-3">
                    <div class="card-body">
                        <?php if(file_exists($invitee->profile_photo)): ?>
                        <div class="mb-3">
                            <img src="<?php echo e(file_exists($invitee->profile_photo) ? asset($invitee->profile_photo) : 'N/A'); ?>" class="w-50 img-thumbnail" alt="<?php echo e($invitee->first_name); ?>" />
                        </div>
                        <?php endif; ?>
                        <?php if(strtolower($invitee->status) == 1): ?>
                        <label for="status" class="form-label">
                            Status
                        </label>
                            <span class="btn btn-sm btn-success">Approved</span>
                        <?php else: ?>
                        <label for="status" class="form-label">
                            Status
                        </label>
                            <span class="btn btn-sm btn-secondary">Pending</span>
                            <br>
                        <label for="">Click to approve</label>
                        <form action="<?php echo e(route('admin.approve-invitee', $invitee->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <button type="submit" onclick="return confirm('Are you sure you want to approve this Invitee?')" class="btn btn-success btn-sm" title="Confirm Payment">Approve</button>
                        </form>

                        <?php endif; ?>


                    </div>

                </div>
                <!-- /.card -->

            </div>

        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/beconline/register.believerscampmeeting.com/resources/views/admin/invitee/details.blade.php ENDPATH**/ ?>