<?php

namespace App\Http\Controllers\Auth;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Mail\EmailVerification;
use Illuminate\Validation\Rules;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Validator as ValidatorCustom;

class ForgotPasswordController extends Controller
{
    function index() 
    {
        return view('auth.forgot-password');  
    }

    function verifyUser(Request $request) 
    {
        $request->validate([
            'username' => ['required']
        ], [
            'username.requred' => 'Username is required'
        ]);

       
        $user = User::where('username',$request->username)->first();

        if (!$user) {
            return redirect()
                ->route('forgot-password.index')
                ->with('error', 'Username inputted does not match our record.');
        }

        $user->email_code =  rand(100000,999999);
        $user->save();

        session(['resetPasswordUser' => $user]);

        $this->sendEmail($user);
        
        return redirect()
            ->route('forgot-password.verify-code.show')
            ->with('status', 'A verification code sent to your email address.');
    }

    function show() 
    {
        return view('auth.forgot-password-verify-code');
    }

    public function verify(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'email_code' => 'required'
        ]);

        $user = session('resetPasswordUser');
        if (!$user) {
            return redirect()
                ->route('forgot-password.index')
                ->with('error', 'Something went wrong, please try it again later');
        }
        
        $user = User::where(['email_code' => $request->email_code, 'id' => $user->id])->first();

        if (!$user) {
            $validate->after(function (ValidatorCustom $validate) {
                $validate->errors()->add('invalid', 'Invalid verification code, please try it again.');
            });
        }
        
        if ($validate->fails()) {
            return redirect()->route('forgot-password.index')->withErrors($validate);
        }

        $user->email_verified_at = Carbon::now()->toDateTimeString();
        $user->status = 'Active';
        $user->save();
        
        return redirect()
            ->route('password-reset.change-show')
            ->with('status', 'Email verification was successful');
    }

    function showChangePassword() 
    {
        return view('auth.forgot-password-change-password');
    }

    function changePassword(Request $request) 
    {
        $request->validate([
            'password' => ['required', 'confirmed', Rules\Password::min(6)]
        ]);

        $user = session('resetPasswordUser');
        if (!$user) {
            return redirect()
                ->route('forgot-password.index')
                ->with('error', 'Something went wrong, please try it again later');
        }
        
        User::where('id', $user->id)->update(['password' => Hash::make($request->password)]);

        return redirect()
            ->route('login')
            ->with('status', 'Password Change successfully!');        
    }

    public function resendCode()
    {
        $user = session('resetPasswordUser');
        
        return redirect()
            ->route('forgot-password.index')
            ->with('error', 'Something went wrong, please try it again later');

        $this->sendEmail($user);

        return redirect()->route('verifyEmail')->with('status', 'A verification code has been sent successfully');
    }

    private function sendEmail($user)
    {
        $user->email_code = rand(100000,999999);
        $user->save();

        Mail::to($user)->send(new EmailVerification($user));

        return true;
    }
}
