<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    function showLoginForm() 
    {
        return view('auth.login');
    }

    function process(Request $request) 
    {

        if (!$request->username) {
            return response()->json(['status' => 'error', 'message' => 'Username is required.']);
        }
        if (!$request->password) {
            return response()->json(['status' => 'error', 'message' => 'Password is required.']);
        }

        $user = User::where('username', $request->username)->first();
        // dd($user->status);

        if ($user) {
            if ($user->status == 'Blocked' || $user->status == 'Suspended') {
                return response()->json(['status' => 'error', 'message' => 'Your account is BLOCKED or suspended, please contact the administrator for Activation!']);
            }
        }
        if (Auth::guard('web')->attempt(['username' => $request->username, 'password' => $request->password])) {
            Auth::guard('web')->login($user);
            return response()->json(['status' => 'success', 'message' => 'Login Successful, Redirecting......']);
            //return redirect()->route('dashboard');
        } else {
            return response()->json(['status' => 'error', 'message' => 'Username And Password Do not Match']);
        }
       
       
    }
}
