<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'category_id',
        'sku',
        'name',
        'featured_img',
        //'hover_img',
        'vat',
        'price',
        'point_value',
        'sold',
        'quantity',
        'available_quantity',
        'vat',
        'status',
        'description'
    ];
    function category(): BelongsTo
    {
        return $this->belongsTo(ProductCategory::class, 'category_id');
    }
    // function faqs(): HasMany
    // {
    //     return $this->HasMany(ProductFaq::class, 'product_id');
    // }
}
