<?php

namespace App\Services;

use App\Models\Category;
use App\Models\Configuration;
use App\Models\Content;
use App\Models\LegalContent;
use App\Models\WebsiteSetting;
use Illuminate\Support\Facades\Cache;

class CacheService
{
    public static $duration;

    function __construct () {
        self::$duration = now()->addMinutes(10);
    }

    private static function cachePrefix()
    {
        $iso = strtoupper('NG');
		if (env('APP_ENV') != 'local') {
			$iso = isset($_SERVER["HTTP_CF_IPCOUNTRY"]) ? strtoupper($_SERVER["HTTP_CF_IPCOUNTRY"]) : 'NG';
		};

        return $iso;
    }

    static function store($key, $value, $duration=null)
    {
        $customizedKey = self::cachePrefix().'|'.$key;
        return Cache::put($customizedKey, $value, $duration ?: self::$duration);
    }

    static function get($key, $return=null)
    {
        $customizedKey = self::cachePrefix().'|'.$key;
        return Cache::get($customizedKey, $return);
    }

    static function configuration()
    {
        return Cache::remember('configuration', self::$duration, function () {
            return Configuration::first();
        });
    }

    static function websiteSetting()
    {
        return Cache::remember('websiteSetting', self::$duration, function () {
            return WebsiteSetting::first();
        });
    }

    static function category()
    {
        return Cache::remember('category', self::$duration, function () {
            // return Category::with('subCategories')->get();
        });
    }

    // static function content()
    // {
    //     return Cache::remember('content', self::$duration, function () {
    //         return Content::get();
    //     });
    // }

    // static function legalContent()
    // {
    //     return Cache::remember('legalContent', self::$duration, function () {
    //         return LegalContent::get();
    //     });
    // }

    static function remove($key)
    {
        return Cache::forget($key);
    }

    static function removeAll()
    {
        return Cache::flush();
    }

}
