<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\EmailTemplate;

class EmailTemplateService
{
  
    public static function allTemplates($take)
    {
        return EmailTemplate::latest('id')->paginate($take ?: 20);
    }
   
    public static function storeTemplate($data)
    {
        EmailTemplate::create([
            'title' => $data->title,
            'content' => $data->content,
            'footer' => $data->footer,
        ]);

    }
    public static function updateTemplate($id,$data)
    {
        $template = EmailTemplate::find($id);
        $template->update([
            'title' => $data->title,
            'content' => $data->content,
            'footer' => $data->footer,
        ]);     
    }
   
    public static function getTemplate($id)
    {
        return EmailTemplate::find($id);      
    }

  
}
