<?php

namespace App\Services;

use App\Models\AdminLog;
use App\Models\Package;
use App\Models\RankQualification;
use Illuminate\Support\Facades\Auth;

class PackageService
{
    public static function allRanks($take)
    {
        return Package::oldest('id')->paginate($take ?: 20);
    }


    public static function edit($id)
    {
        return Package::find($id);
    }
    public static function update($id, $data)
    {

        $package = Package::find($id);
        $package->update([
            'name' => $data->name,
            'min_pv' => $data->min_pv,
            'referral_perc' => $data->referral_perc,
            'sales_perc' => $data->sales_perc,
            'binary_perc' => $data->binary_perc,
            'daily_match' => $data->daily_match,
        ]);
        AdminLog::createAdminLog(
            Auth::user()->id,
            $package->id,
            'packages',
            ucfirst(Auth::user()->username) . ' Updated Package Detials'
        );
    }
}
