@extends('layouts.admin')
@section('title', 'Invitees Manager')
@section('content')

    <div class="min-height-200px">
        <div class="page-header">
            <div class="row">
                <div class="col-md-6 col-sm-12">
                    <div class="title">
                        <h4>Invitees Manager</h4>
                    </div>
                    <nav aria-label="breadcrumb" role="navigation">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('adminDashboard') }}">Admin</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                Invitees Manager
                            </li>
                        </ol>
                    </nav>
                </div>
                {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.epins.create')}}" role="button">
            <i class="bi bi-plus-circle"></i>
            New Code
            </a>

        </div>
    </div> --}}
            </div>
        </div>

        <div class="row pb-10">
            <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
                <div class="card-box height-100-p widget-style3">
                    <div class="d-flex flex-wrap">
                        <div class="widget-data">
                            <div class="weight-700 font-24 text-dark">{{ number_format($userStats->total_invitees) }}</div>
                            <div class="font-14 text-secondary weight-500">
                                All Invitees
                            </div>
                        </div>
                        <div class="widget-icon">
                            <div class="icon" data-color="#00eccf">
                                <i class="icon-copy bi bi-people"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
                <div class="card-box height-100-p widget-style3">
                    <div class="d-flex flex-wrap">
                        <div class="widget-data">
                            <div class="weight-700 font-24 text-dark">{{ number_format($invitees_without_images) }}</div>
                            <div class="font-14 text-secondary weight-500">
                                Invitees without Profile Photo
                            </div>
                        </div>
                        <div class="widget-icon">
                            <div class="icon" data-color="#00eccf">
                                <i class="icon-copy bi bi-people"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-6 mb-20">
                <div class="card-box height-100-p widget-style3">
                    <div class="d-flex flex-wrap">
                        <div class="widget-data">
                            <div class="weight-700 font-24 text-dark">{{ number_format($invitees_with_images) }}</div>
                            <div class="font-14 text-secondary weight-500">
                                Invitees with Profile Photo
                            </div>
                        </div>
                        <div class="widget-icon">
                            <div class="icon" data-color="#00eccf">
                                <i class="icon-copy bi bi-people"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card-box pb-10">
            <div class="h5 pd-20 mb-0"></div>
            @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> {{ session('message') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>Error!</strong> {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            @if (session('errorMessage'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>Error!</strong> {{ session('errorMessage') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            <div class="card-tools float-left px-3 my-2">
                <form action="{{ request()->url() }}" method="GET">
                    <div class="d-flex">
                        <div class="input-group input-group-sm mx-3" style="width: 300px;">
                            <input type="text" style="height:35px" required class="form-control"
                                value="{{ request()->search ?? '' }}"
                                placeholder="Search invitee by First Name or phone number" name="search" id="">
                        </div>
                        <div>
                            <button class="btn btn-success btn-sm" type="submit">Search</button>
                            <a class="btn btn-primary btn-sm" href="{{ request()->url() }}">Reset</a>
                        </div>

                    </div>
                </form>
                <span class=""><a href="{{ route('export-invitees') }}" class="btn btn-secondary btn-sm">Export
                        CSV</a></span>
                <span class=""><a href="{{ route('export-card-invitees') }}" target="_blank"
                        class="btn btn-primary btn-sm">Generate Id card</a></span>

            </div>
            <div class="card-tools float-right px-3">
                <form action="{{ request()->url() }}" method="GET">
                    <div class="input-group input-group-sm" style="width: 150px;">
                        <select name="take" class="form-control" onchange="this.form.submit()">
                            <option value="">-- per Page --</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                            <option value="150">150</option>
                        </select>
                    </div>
                </form>
            </div>
            <table class="table nowrap">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Acomodation</th>
                        <th>Profile Image</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th class="datatable-nosort">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($invitees as $invitee)
                        <tr>
                            <td>{{ ucfirst($invitee->first_name) }}</td>

                            <td>
                                {{ $invitee->author_email ?? 'N/A' }}
                            </td>

                            <td>{{ ucfirst($invitee->accomodation) }}</td>

                            <td>
                                @if ($invitee->profile_photo)
                                    <span class="btn btn-sm btn-success text-white">Uploaded</span>
                                @else
                                    <span class="btn btn-sm btn-danger text-white">Absent</span>
                                @endif
                            </td>
                            <td>
                                @if ($invitee->status == 'Pending')
                                    <span class="btn btn-sm btn-secondary text-white">Pending</span>
                                @else
                                    <span class="btn btn-sm btn-success text-white">Approved</span>
                                @endif
                            </td>
                            <td>
                                <x-date-format :date="$invitee->created_at" />
                            </td>
                            <td>
                                <a href="{{ route('invitee.details', $invitee->id) }}"
                                    class="btn btn-info btn-sm text-white">
                                    <i class="fa fa-eye"></i>
                                </a>

                            </td>
                        </tr>
                    @empty
                        <table>
                            <tr>
                                <p class="text-center">No record found</p>
                            </tr>
                        </table>
                    @endforelse


                </tbody>
            </table>
            <div class="px-3">{{ $invitees->withQueryString()->links() }}</div>
        </div>
    </div>

@endsection
