@extends('layouts.admin')
@section('title','About Us')
@section('content')

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>About Us</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{route('adminDashboard')}}">Admin</a>
                        </li>

                        <li class="breadcrumb-item active" aria-current="page">
                            About Us
                        </li>
                    </ol>
                </nav>
            </div>
            {{-- <div class="col-md-6 col-sm-12 text-right">
                <div class="dropdown">
                    <a class="btn btn-primary" href="{{route('admin.admins.index')}}" role="button">
            Admin Manager
            </a>

        </div>
    </div> --}}
</div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="pd-20 card-box mb-30">
            @if (session('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{session('message')}}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            <form role="form" action="{{route('admin.about-us-update')}}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for=" ">Hero Heading</label>
                                <input type="text" value="{{$about_us ? $about_us->hero_heading : ''}}" class="form-control" name="hero_heading">
                            </div>
                        </div>
                        <div class="col-md-6">
                            @if($about_us && file_exists($about_us->hero_banner))
                            <img src="{{asset($about_us->hero_banner)}}" class="img-thumbnail w-50" alt="">
                            @endif
                            <div class="form-group">
                                <label for="">Hero Banner</label>
                                <input type="file" class="form-control" name="hero_banner">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for=" ">Hero Text</label>
                                <textarea name="hero_text" id="" class="form-control" cols="10" rows="10">{{$about_us ? $about_us->hero_text : ''}}</textarea>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for=" ">History Text</label>
                                <textarea name="history_text" id="" class="form-control" cols="10" rows="10">{{$about_us ? $about_us->history_text : ''}}</textarea>
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            @if($about_us && file_exists($about_us->ceo_signature))
                            <img src="{{asset($about_us->ceo_signature)}}" class="img-thumbnail w-50" alt="">
                            @endif
                            <div class="form-group">
                                <label for=" ">Ceo Signature </label>
                                <input type="file" class="form-control" name="ceo_signature">
                            </div>
                        </div>
                        <div class="col-md-4">
                            @if($about_us && file_exists($about_us->history_image))
                            <img src="{{asset($about_us->history_image)}}" class="img-thumbnail w-50" alt="">
                            @endif
                            <div class="form-group">
                                <label for=" ">Ceo Image </label>
                                <input type="file" class="form-control" name="history_image">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Ceo Name</label>
                                <input type="text" class="form-control" name="ceo_name" value="{{$about_us ? ucfirst($about_us->ceo_name) : ''}}">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading one </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_one : ''}}" name="benefit_heading_one">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading two </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_two : ''}}" name="benefit_heading_two">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading three </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_three : ''}}" name="benefit_heading_three">
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading four </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_four : ''}}" name="benefit_heading_four">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading five </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_five : ''}}" name="benefit_heading_five">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for=" ">Benefit heading six </label>
                                <input type="text" class="form-control" value="{{$about_us ? $about_us->benefit_heading_six : ''}}" name="benefit_heading_six">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text one </label>
                                <textarea name="benefit_text_one" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_one : ''}}</textarea>
                            </div>
                        </div>


                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text two </label>
                                <textarea name="benefit_text_two" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_two : ''}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text three </label>
                                <textarea name="benefit_text_three" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_three : ''}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text four </label>
                                <textarea name="benefit_text_four" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_four : ''}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text five </label>
                                <textarea name="benefit_text_five" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_five : ''}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Benefit text six </label>
                                <textarea name="benefit_text_six" class="form-control" cols="30" rows="10">{{$about_us ? $about_us->benefit_text_six : ''}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            @if($about_us && file_exists($about_us->support_image_one))
                            <img src="{{asset($about_us->support_image_one)}}" class="img-thumbnail w-50" alt="">
                            @endif
                            <div class="form-group">
                                <label for="">Support image one</label>
                                <input type="file" name="support_image_one" id="">
                            </div>
                        </div>
                        <div class="col-md-6">
                            @if($about_us && file_exists($about_us->support_image_two))
                            <img src="{{asset($about_us->support_image_two)}}" class="img-thumbnail w-50" alt="">
                            @endif
                            <div class="form-group">
                                <label for="">Support image two</label>
                                <input type="file" name="support_image_two" id="">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support heading one </label>
                                <input type="text" name="support_heading_one" class="form-control" value="{{$about_us ? $about_us->support_heading_one : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support sub-heading one </label>
                                <input type="text" name="support_subheading_one" class="form-control" value="{{$about_us ? $about_us->support_subheading_one : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support text one </label>
                                <input type="text" name="support_text_one" class="form-control" value="{{$about_us ? $about_us->support_text_one : ''}}" />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support heading two </label>
                                <input type="text" name="support_heading_two" class="form-control" value="{{$about_us ? $about_us->support_heading_two : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support sub-heading two </label>
                                <input type="text" name="support_subheading_two" class="form-control" value="{{$about_us ? $about_us->support_subheading_two : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Support text two </label>
                                <input type="text" name="support_text_two" class="form-control" value="{{$about_us ? $about_us->support_text_two : ''}}" />
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Product Sold </label>
                                <input type="text" name="product_sold" class="form-control" value="{{$about_us ? $about_us->product_sold : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Reseller </label>
                                <input type="text" name="reseller" class="form-control" value="{{$about_us ? $about_us->reseller : ''}}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="">Happy Customer</label>
                                <input type="text" name="customer" class="form-control" value="{{$about_us ? $about_us->customer : ''}}" />
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->

                <div class="form-group">
                    <button type="submit" class="btn btn-primary">Update Setting</button>
                </div>
            </form>


        </div>
    </div>

</div>

</div>

@endsection
