<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{
    use HasFactory;
    protected $fillable =[
        'user_id',
        'ticket_number',
        'sender',
        'subject',
        'message',
        'attachments',
        'type',
        'status',
        'is_read',
    ];

    public function comments()
    {
        return $this->hasMany(SupportTicketComment::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
