<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserWallet extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'master_wallet',
        'transaction_wallet',
        'welcome_b',
        'referral_b',
        'binary_b',
        'team_b',
        'unilevel_activation_b',
        'rank_b',
        'leadership_b',
        'residual_b',
        'promo_b',
        'direct_sales_b',
        'indirect_sales_b',
        'payout_update'
    ];

    public function user(): BelongsTo
    {
        return $this->BelongsTo(User::class, 'user_id')->withDefault([
            'name' => 'guest',
        ]);
    }

    public static function userEarningSstats($id)
    {
        return DB::select(
            "SELECT
            (SELECT ROUND(SUM(`welcome_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS welcome_b,
                (SELECT ROUND(SUM(`influencer_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS influencer_b,
                (SELECT ROUND(SUM(`referral_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS referral_b,
                (SELECT ROUND(SUM(`binary_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS binary_b,
                (SELECT ROUND(SUM(`team_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS team_b,
                (SELECT ROUND(SUM(`unilevel_activation_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS unilevel_activation_b,
                (SELECT ROUND(SUM(`unilevel_matching_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS unilevel_matching_b,
                (SELECT ROUND(SUM(`three_to_infinity_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS three_to_infinity_b,
                (SELECT ROUND(SUM(`stockist_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS stockist_b,
                (SELECT ROUND(SUM(`rank_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS rank_b,
                (SELECT ROUND(SUM(`promo_b`), 2) FROM `user_wallets` WHERE `user_id`=$id) AS promo_b 


            "
        )[0];
    }


    public static function earningStats($userID)
    {
        return DB::select(
            "SELECT
                (SELECT master_wallet FROM `user_wallets` WHERE user_id=$userID) AS master_wallet,
                (SELECT transaction_wallet FROM `user_wallets` WHERE user_id=$userID) AS transaction_wallet,
                (SELECT SUM(`amount`) FROM `income_wallets` WHERE user_id=$userID) AS total_earnings,
                (SELECT SUM(`debit`) FROM `transaction_wallets` WHERE user_id=$userID) AS total_spent,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='approved') AS approved_payout,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='pending') AS pending_payout,
                (SELECT (SUM(`amount`) + SUM(`fee`)) FROM `payouts` WHERE user_id=$userID AND status='cancelled') AS cancelled_payout,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='direct' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS direct_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='repurchase' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS repurchase_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='binary' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS binary_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE user_id=$userID AND
                        type='rank' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS rank_commission_month
            "
        )[0];
    }

    public static function stats()
    {
        return DB::select(
            "SELECT
                (SELECT ROUND(SUM(`master_wallet`), 2) FROM `user_wallets`) AS master_wallet_available,
                (SELECT ROUND(SUM(`transaction_wallet`), 2) FROM `user_wallets`) AS transaction_wallet_available,
                (SELECT ROUND(SUM(`debit`), 2) FROM `transaction_wallets`) AS total_spent,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets`) AS total_commissions,

                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='welcome') AS total_welcome_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='referral') AS total_referral_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='binary') AS total_binary_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='rank') AS total_rank_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='team_bonus') AS total_team_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='unilevel_activation') AS total_unilevel_activation_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='sales') AS total_sales_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='residual') AS total_residual_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='leadership') AS total_leadership_commission,
                (SELECT ROUND(SUM(`amount`), 2) FROM `income_wallets` WHERE type='promo') AS total_promo_commission,
-- Today
                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='welcome' AND
                    DAY(created_at) = DAY(NOW())
                ) AS welcome_commission_today,               
              
                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='referral' AND
                    DAY(created_at) = DAY(NOW())
                ) AS referral_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='binary' AND
                    DAY(created_at) = DAY(NOW())
                ) AS binary_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='rank' AND
                    DAY(created_at) = DAY(NOW())
                ) AS rank_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='team_bonus' AND
                    DAY(created_at) = DAY(NOW())
                ) AS team_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='unilevel_activation' AND
                    DAY(created_at) = DAY(NOW())
                ) AS unilevel_activation_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='sales' AND
                    DAY(created_at) = DAY(NOW())
                ) AS sales_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='residual' AND
                    DAY(created_at) = DAY(NOW())
                ) AS residual_commission_today,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='leadership' AND
                    DAY(created_at) = DAY(NOW())
                ) AS leadership_commission_today,

                
                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='promo' AND
                    DAY(created_at) = DAY(NOW())
                ) AS promo_commission_today,

-- Weekly

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='welcome' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS welcome_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='referral' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS referral_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='binary' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS binary_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='rank' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS rank_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                   FROM `income_wallets`
                    WHERE type='team_bonus' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS team_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='unilevel_activation' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS unilevel_activation_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                  FROM `income_wallets`
                    WHERE type='sales' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS sales_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='residual' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS residual_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='leadership' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS leadership_commission_this_week,

                (SELECT ROUND(SUM(`amount`), 2)
                 FROM `income_wallets`
                    WHERE type='promo' AND
                    WEEK(created_at) = WEEK(NOW())
                ) AS promo_commission_this_week,

       -- Monthly        
                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='welcome' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS welcome_commission_month,

             
                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='team_bonus' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS team_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='unilevel_activation' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS unilevel_activation_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='sales' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS sales_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='residual' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS residual_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='promo' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS promo_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='leadership' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS leadership_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='referral' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS referral_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='binary' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS binary_commission_month,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='rank' AND
                        MONTH(created_at) = MONTH(NOW()) AND
                        YEAR(created_at) = YEAR(NOW())
                ) AS rank_commission_month,

    -- Yearly
                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='welcome' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS welcome_commission_this_year,

               
                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='team_bonus' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS team_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='unilevel_activation' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS unilevel_activation_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='sales' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS sales_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='residual' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS residual_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='promo' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS promo_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='leadership' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS leadership_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='referral' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS referral_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='binary' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS binary_commission_this_year,

                (SELECT
                    ROUND(SUM(`amount`), 2)
                    FROM `income_wallets`
                    WHERE type='rank' AND
                    YEAR(created_at) = YEAR(NOW())
                ) AS rank_commission_this_year

                 "
        )[0];
    }
}
