@extends('layouts.admin')
@section('title', 'Chat')
@section('content')


    <div class="pd-ltr-20 xs-pd-20-10">
        <div class="min-height-200px">
            <div class="page-header">
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="title">
                            <h4>Chat</h4>
                        </div>
                        <nav aria-label="breadcrumb" role="navigation">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Chat</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="mb-30">
                <div class="row mb-5">
                    <div class="col-md-12">
                        <div class="chat-search">
                            <span class="ti-search"></span>
                            <input type="text" placeholder="Search Contact">
                        </div>
                    </div>
                </div>
                <div class="row">
                    @forelse ($users as $user)
                        <div class="col-lg-3">
                            <div class="card">
                                <div class="card-body">
                                    <a href="{{ route('chatDetails', $user->id) }}">
                                        <img src="{{ asset('admin-ui/images/vendors/images/img.jpg') }}" alt="">
                                        <h3 class="clearfix">{{ $user->username }}</h3>
                                        <p><i class="fa fa-circle text-light-green"></i> online</p>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-center">No record found</p>
                    @endforelse

                </div>
            </div>
        </div>

    </div>
@endsection
