
<?php $__env->startSection('title','Website Setting'); ?>
<?php $__env->startSection('content'); ?>

<div class="min-height-200px">
    <div class="page-header">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="title">
                    <h4>Website Setting</h4>
                </div>
                <nav aria-label="breadcrumb" role="navigation">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('adminDashboard')); ?>">Admin</a>
                        </li>
                        
                        <li class="breadcrumb-item active" aria-current="page">
                            Website Setting
                        </li>
                    </ol>
                </nav>
            </div>
            
        </div>
    </div>
    <div class="row">
        <div class="col-md-10">
            <div class="pd-20 card-box mb-30">
                <?php if(session('message')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Success!</strong> <?php echo e(session('message')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>
                <form role="form" action="<?php echo e(route('admin.website-update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=" ">Site Name</label>
                                    <input type="text" value="<?php echo e($site_content ? $site_content->name : ''); ?>" class="form-control"
                                        name="name">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=" ">Business Name</label>
                                    <input type="text" class="form-control" value="<?php echo e($site_content ? $site_content->business_name : ''); ?>"
                                        name="business_name">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=" ">Business Address </label>
                                    <input name="business_address" class="form-control" value="<?php echo e($site_content ? $site_content->business_address : ''); ?>" />
                                </div>
                            </div>
                          

                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=" ">Business Phone</label>
                                    <input name="business_phone" type="text" class="form-control"
                                        value="<?php echo e($site_content ? $site_content->business_phone : ''); ?>" />
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=" ">Business Email</label>
                                    <input type="email" value="<?php echo e($site_content ? $site_content->business_email : ''); ?>"
                                        class="form-control" name="business_email">
                                </div>
                            </div>
                        </div>

                      
                       
                       
                   


                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Update Setting</button>
                    </div>
                </form>


            </div>
        </div>
      
    </div>

    <div class="row pt-3">
        <!-- left column -->
        <div class="col-md-10">
            <!-- general form elements -->
            <div class="pd-20 card-box mb-30">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <form action="<?php echo e(route('admin.updateSiteLogo')); ?>" enctype="multipart/form-data"
                                method="POST">
                                <?php echo method_field('PUT'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for=" "> Site Logo </label>
                                    <input type="file" onchange="this.form.submit()" class="form-control"
                                        name="logo_url" accept="image/*">
                                </div>
                            </form>
                            <?php if($site_content): ?>
                            <img src="<?php echo e($site_content ? asset($site_content->logo_url) : ''); ?>" alt="Site Logo" width="100" height="100"
                                class="img-thumbnail">
                            <?php endif; ?>

                        </div>
                        <div class="col-md-4">
                            <form action="<?php echo e(route('admin.updateDashboardLogo')); ?>" enctype="multipart/form-data"
                                method="POST">
                                <?php echo method_field('PUT'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="">Dashboard Logo</label>
                                    <input type="file" onchange="this.form.submit()" class="form-control"
                                        name="dashboard_logo_url" accept="image/*">
                                </div>
                            </form>
                            <?php if($site_content): ?>
                            <img src="<?php echo e($site_content ? asset($site_content->dashboard_logo_url) : ''); ?>" alt="Site Logo" width="100"
                                height="100" class="img-thumbnail">
                            <?php endif; ?>
                        </div>
                        <div class="col-md-4">
                            <form action="<?php echo e(route('admin.updateSiteFavicon')); ?>" enctype="multipart/form-data"
                                method="POST">
                                <?php echo method_field('PUT'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for=" ">Favicon</label>
                                    <input type="file" onchange="this.form.submit()" class="form-control"
                                        name="favicon_url" accept="image/*">
                                </div>
                            </form>
                            <?php if($site_content): ?>
                            <img src="<?php echo e($site_content ? asset($site_content->favicon_url) : ''); ?>" alt="Site Logo" width="100" height="100"
                                class="img-thumbnail">
                            <?php endif; ?>
                        </div>
                      
                    </div>
                </div>

            </div>
            <!-- /.card -->

        </div>

        <!--/.col (right) -->
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Dell Latitude\Desktop\Projects\event-app\resources\views/admin/setting/website-setting.blade.php ENDPATH**/ ?>